/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.cp.solver.search.SearchLoop;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.Arithm;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractOptimize;

public class OptimizeWithRestarts
extends AbstractOptimize {
    protected int nbIter = 0;
    protected int baseNbSol = 0;
    protected int nbBkTot = 0;
    protected int nbNdTot = 0;

    public OptimizeWithRestarts(IntDomainVarImpl obj, boolean maximize) {
        super(obj, maximize);
        this.setSearchLoop(new SearchLoop(this));
    }

    protected void newLoop() throws ContradictionException {
        ++this.nbIter;
        this.baseNbSol = this.nbSolutions;
        this.postTargetBound();
        this.solver.propagate();
    }

    protected void endLoop() {
        for (int i = 0; i < this.limits.size(); ++i) {
            AbstractGlobalSearchLimit lim = (AbstractGlobalSearchLimit)this.limits.get(i);
            lim.reset(false);
        }
        this.popTraceUntil(this.baseWorld + 1);
        this.solver.worldPopUntil(this.baseWorld + 1);
    }

    private void recordNoSolution() {
        if (this.doMaximize) {
            this.upperBound = Arithm.min(this.upperBound, this.getObjectiveTarget() - 1);
        } else {
            this.lowerBound = Arithm.max(this.lowerBound, this.getObjectiveTarget() + 1);
        }
    }

    protected boolean oneMoreLoop() {
        return this.lowerBound < this.upperBound;
    }

    @Override
    public void incrementalRun() {
        this.initBounds();
        super.incrementalRun();
    }

    @Override
    public Boolean nextSolution() {
        Boolean bool;
        if (!this.oneMoreLoop()) {
            return Boolean.FALSE;
        }
        try {
            this.newLoop();
            this.nextMove = 0;
            this.traceStack.clear();
            this.currentTraceIndex = -1;
            bool = super.nextSolution();
        }
        catch (ContradictionException e) {
            bool = Boolean.FALSE;
        }
        this.endLoop();
        return bool;
    }
}

