/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.propagation.EventQueue;
import choco.kernel.solver.propagation.PropagationEvent;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VarEventStack
implements EventQueue {
    protected Stack<PropagationEvent> queue = new Stack();
    protected PropagationEvent lastPopped = null;
    private static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void propagateSomeEvents() throws ContradictionException {
        while (this.queue.size() != 0) {
            PropagationEvent evt = this.popEvent();
            evt.propagateEvent();
        }
    }

    @Override
    public void propagateOneEvent() throws ContradictionException {
        if (this.queue.size() != 0) {
            this.popEvent();
        }
    }

    @Override
    public PropagationEvent popEvent() {
        PropagationEvent event;
        this.lastPopped = event = this.queue.pop();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("just popped " + event.toString());
        }
        return event;
    }

    @Override
    public boolean pushEvent(PropagationEvent event) {
        this.queue.push(event);
        return true;
    }

    @Override
    public void flushEventQueue() {
        if (null != this.lastPopped) {
            this.lastPopped.clear();
        }
        for (PropagationEvent event : this.queue) {
            event.clear();
        }
        this.queue.clear();
    }

    @Override
    public void remove(PropagationEvent event) {
        this.queue.remove(event);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public PropagationEvent get(int idx) {
        for (PropagationEvent event : this.queue) {
            if (idx == 0) {
                return event;
            }
            --idx;
        }
        return null;
    }
}

