/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.cp.solver.variables.real.RealVarImpl;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.RealVarEventListener;
import choco.kernel.solver.propagation.VarEvent;
import choco.kernel.solver.variables.real.RealVar;
import java.util.logging.Level;

public class RealVarEvent
extends VarEvent<RealVarImpl> {
    public static final int INCINF = 0;
    public static final int DECSUP = 1;
    public static final int EMPTYEVENT = 0;
    public static final int BOUNDSEVENT = 3;
    public static final int INFEVENT = 1;
    public static final int SUPEVENT = 2;

    public RealVarEvent(RealVarImpl var) {
        super(var);
    }

    public String toString() {
        return "VarEvt(" + ((RealVarImpl)this.modifiedVar).toString() + ")[" + this.eventType + ":" + ((this.eventType & 1) != 0 ? "I" : "") + ((this.eventType & 2) != 0 ? "S" : "") + "]";
    }

    @Override
    public void clear() {
        this.eventType = 0;
        ((RealVarImpl)this.modifiedVar).getDomain().clearDeltaDomain();
    }

    @Override
    protected boolean release() {
        return ((RealVarImpl)this.modifiedVar).getDomain().releaseDeltaDomain();
    }

    @Override
    protected void freeze() {
        ((RealVarImpl)this.modifiedVar).getDomain().freezeDeltaDomain();
        this.cause = -2;
        this.eventType = 0;
    }

    public boolean getReleased() {
        return ((RealVarImpl)this.modifiedVar).getDomain().getReleasedDeltaDomain();
    }

    @Override
    public boolean propagateEvent() throws ContradictionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("propagate " + this.toString());
        }
        int evtType = this.eventType;
        int evtCause = this.cause;
        this.freeze();
        if (evtType <= 3) {
            if (evtType == 1) {
                this.propagateInfEvent(evtCause);
            } else if (evtType == 2) {
                this.propagateSupEvent(evtCause);
            } else if (evtType == 3) {
                this.propagateBoundsEvent(evtCause);
            }
        }
        return this.release();
    }

    public void propagateSupEvent(int evtCause) throws ContradictionException {
        RealVar v = (RealVar)this.getModifiedVar();
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        DisposableIntIterator cit = constraints.getIndexIterator();
        while (cit.hasNext()) {
            RealVarEventListener c;
            int idx = cit.next();
            if (idx == evtCause || !(c = (RealVarEventListener)constraints.get(idx)).isActive()) continue;
            int i = indices.get(idx);
            c.awakeOnSup(i);
        }
    }

    public void propagateInfEvent(int evtCause) throws ContradictionException {
        RealVar v = (RealVar)this.getModifiedVar();
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        DisposableIntIterator cit = constraints.getIndexIterator();
        while (cit.hasNext()) {
            RealVarEventListener c;
            int idx = cit.next();
            if (idx == evtCause || !(c = (RealVarEventListener)constraints.get(idx)).isActive()) continue;
            int i = indices.get(idx);
            c.awakeOnInf(i);
        }
    }

    public void propagateBoundsEvent(int evtCause) throws ContradictionException {
        RealVar v = (RealVar)this.getModifiedVar();
        PartiallyStoredVector<SConstraint> constraints = v.getConstraintVector();
        PartiallyStoredIntVector indices = v.getIndexVector();
        DisposableIntIterator cit = constraints.getIndexIterator();
        while (cit.hasNext()) {
            RealVarEventListener c;
            int idx = cit.next();
            if (idx == evtCause || !(c = (RealVarEventListener)constraints.get(idx)).isActive()) continue;
            int i = indices.get(idx);
            c.awakeOnInf(i);
            c.awakeOnSup(i);
        }
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }
}

