/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.cp.solver.propagation.EventQueueFactory;
import choco.cp.solver.variables.integer.IntVarEvent;
import choco.cp.solver.variables.set.SetVarEvent;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.propagation.AbstractPropagationEngine;
import choco.kernel.solver.propagation.ConstraintEvent;
import choco.kernel.solver.propagation.ConstraintEventQueue;
import choco.kernel.solver.propagation.EventQueue;
import choco.kernel.solver.propagation.PropagationEngineListener;
import choco.kernel.solver.propagation.PropagationEvent;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.propagation.VarEvent;
import choco.kernel.solver.propagation.VarEventQueue;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChocEngine
extends AbstractPropagationEngine {
    private static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");
    protected static final int NB_CONST_QUEUES = 1;
    protected static final int NB_VAR_QUEUES = 3;
    private ConstraintEventQueue[] constEventQueues;
    protected int nbPendingInitConstAwakeEvent;
    protected VarEventQueue[] varEventQueue;
    protected ArrayList<PropagationEngineListener> propagationEngineListeners = new ArrayList();
    ContradictionException e = new ContradictionException(null, 0);

    public ChocEngine(Solver solver) {
        super(solver);
        int i;
        this.constEventQueues = new ConstraintEventQueue[1];
        for (i = 0; i < 1; ++i) {
            this.constEventQueues[i] = new ConstraintEventQueue(this);
        }
        this.varEventQueue = new VarEventQueue[3];
        for (i = 0; i < 3; ++i) {
            this.varEventQueue[i] = EventQueueFactory.getVarEventQueue(solver.getEventQueueType());
        }
        this.nbPendingInitConstAwakeEvent = 0;
    }

    @Override
    public void postUpdateInf(IntDomainVar v, int idx) {
        this.postEvent(v, idx, 0);
    }

    @Override
    public void postUpdateSup(IntDomainVar v, int idx) {
        this.postEvent(v, idx, 1);
    }

    @Override
    public void postEvent(Var v, int idx, int basicEvt) {
        VarEvent<? extends Var> event = v.getEvent();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("post Event " + event.toString() + " for basicEvt:" + basicEvt);
        }
        boolean alreadyEnqueued = event.isEnqueued();
        event.recordEventTypeAndCause(basicEvt, idx);
        if (!alreadyEnqueued) {
            this.varEventQueue[event.getPriority()].pushEvent(event);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("posted Event " + event.toString());
        }
    }

    @Override
    public void postInstInt(IntDomainVar v, int idx) {
        this.postEvent(v, idx, 3);
    }

    @Override
    public void postRemoveVal(IntDomainVar v, int x, int idx) {
        this.postEvent(v, idx, 2);
    }

    @Override
    public void postUpdateInf(RealVar v, int idx) {
        this.postEvent(v, idx, 0);
    }

    @Override
    public void postUpdateSup(RealVar v, int idx) {
        this.postEvent(v, idx, 1);
    }

    @Override
    public void postRemEnv(SetVar v, int idx) {
        this.postEvent(v, idx, 0);
    }

    @Override
    public void postAddKer(SetVar v, int idx) {
        this.postEvent(v, idx, 1);
    }

    @Override
    public void postInstSet(SetVar v, int idx) {
        this.postEvent(v, idx, 2);
    }

    @Override
    public boolean postConstAwake(Propagator constraint, boolean init) {
        ConstraintEvent event = (ConstraintEvent)constraint.getEvent();
        ConstraintEventQueue queue = this.getQueue(event);
        if (queue.pushEvent(event)) {
            event.setInitialized(!init);
            if (init) {
                this.incPendingInitConstAwakeEvent();
            }
            return true;
        }
        return false;
    }

    @Override
    public ConstraintEventQueue getQueue(ConstraintEvent event) {
        int prio = 0;
        if (prio < 1) {
            return this.constEventQueues[prio];
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("wrong constraint priority. It should be between 0 and 3.");
        }
        return this.constEventQueues[3];
    }

    @Override
    public void registerEvent(ConstraintEvent event) {
        ConstraintEventQueue queue = this.getQueue(event);
        queue.add(event);
    }

    @Override
    public VarEventQueue[] getVarEventQueues() {
        return this.varEventQueue;
    }

    @Override
    public void setVarEventQueues(VarEventQueue[] veqs) {
        for (int i = 0; i < this.varEventQueue.length; ++i) {
            this.varEventQueue[i] = veqs[i];
        }
    }

    @Override
    public void setVarEventQueues(int eventQueueType) {
        for (int i = 0; i < this.varEventQueue.length; ++i) {
            this.varEventQueue[i] = EventQueueFactory.getVarEventQueue(eventQueueType);
        }
    }

    @Override
    public ConstraintEventQueue[] getConstraintEventQueues() {
        return this.constEventQueues;
    }

    @Override
    public void setConstraintEventQueues(ConstraintEventQueue[] ceqs) {
        for (int i = 0; i < this.constEventQueues.length; ++i) {
            this.constEventQueues[i] = ceqs[i];
        }
    }

    @Override
    public void addPropagationEngineListener(PropagationEngineListener listener) {
        this.propagationEngineListeners.add(listener);
    }

    @Override
    public void raiseContradiction(Object cause, int type) throws ContradictionException {
        this.e.set(cause, type);
        for (PropagationEngineListener listener : this.propagationEngineListeners) {
            listener.contradictionOccured(this.e);
        }
        throw this.e;
    }

    @Override
    public void setContradictionCause(Object cause, int type) {
        this.contradictionCause = cause;
    }

    @Override
    public void decPendingInitConstAwakeEvent() {
        --this.nbPendingInitConstAwakeEvent;
    }

    public void incPendingInitConstAwakeEvent() {
        ++this.nbPendingInitConstAwakeEvent;
    }

    public EventQueue getNextActiveConstraintEventQueue() {
        for (int i = 0; i < 1; ++i) {
            if (this.constEventQueues[i].isEmpty()) continue;
            return this.constEventQueues[i];
        }
        return null;
    }

    @Override
    public EventQueue getNextActiveEventQueue() {
        for (int i = 0; i < 3; ++i) {
            if (this.varEventQueue[i].isEmpty()) continue;
            return this.varEventQueue[i];
        }
        return this.getNextActiveConstraintEventQueue();
    }

    public int getNbPendingEvents() {
        int i;
        int nbEvts = 0;
        for (i = 0; i < 3; ++i) {
            nbEvts += this.varEventQueue[i].size();
        }
        for (i = 0; i < 1; ++i) {
            nbEvts += this.constEventQueues[i].size();
        }
        return nbEvts;
    }

    public PropagationEvent getPendingEvent(int idx) {
        int varsSize = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.nbPendingInitConstAwakeEvent > 0) {
                idx += this.varEventQueue[i].size();
            }
            if (idx >= (varsSize += this.varEventQueue[i].size())) continue;
            return this.varEventQueue[i].get(idx);
        }
        ConstraintEventQueue q = null;
        int size = varsSize;
        int qidx = 0;
        while ((idx -= size) > (size = (q = this.constEventQueues[qidx++]).size()) && qidx < 1) {
        }
        if (idx <= size) {
            return q.get(idx);
        }
        if (this.nbPendingInitConstAwakeEvent > 0) {
            for (int i = 0; i < 3; ++i) {
                if (idx >= (varsSize += this.varEventQueue[i].size())) continue;
                return this.varEventQueue[i].get(idx);
            }
        }
        return null;
    }

    @Override
    public void flushEvents() {
        int i;
        for (i = 0; i < 1; ++i) {
            this.constEventQueues[i].flushEventQueue();
        }
        this.nbPendingInitConstAwakeEvent = 0;
        for (i = 0; i < 3; ++i) {
            this.varEventQueue[i].flushEventQueue();
        }
    }

    @Override
    public boolean checkCleanState() {
        boolean ok = true;
        Solver solver = this.getSolver();
        int nbiv = solver.getNbIntVars();
        for (int i = 0; i < nbiv; ++i) {
            IntVarEvent evt = (IntVarEvent)solver.getIntVar(i).getEvent();
            if (evt.getReleased()) continue;
            logger.severe("var event non released " + evt.toString());
            new Exception().printStackTrace();
            ok = false;
        }
        int nbsv = solver.getNbSetVars();
        for (int i = 0; i < nbsv; ++i) {
            SetVarEvent evt = (SetVarEvent)solver.getSetVar(i).getEvent();
            if (evt.getReleased()) continue;
            logger.severe("var event non released " + evt.toString());
            new Exception().printStackTrace();
            ok = false;
        }
        return ok;
    }
}

