/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.propagation.PropagationEvent;
import choco.kernel.solver.propagation.VarEventQueue;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicVarEventQueue
implements VarEventQueue {
    protected Queue<PropagationEvent> queue = new LinkedList<PropagationEvent>();
    protected PropagationEvent lastPopped = null;
    private static Logger logger = Logger.getLogger("choco.kernel.solver.propagation");

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void propagateSomeEvents() throws ContradictionException {
        while (this.queue.size() != 0) {
            PropagationEvent evt = this.popEvent();
            evt.propagateEvent();
        }
    }

    @Override
    public void propagateOneEvent() throws ContradictionException {
        if (this.queue.size() != 0) {
            this.popEvent();
        }
    }

    @Override
    public PropagationEvent popEvent() {
        PropagationEvent event;
        this.lastPopped = event = this.queue.poll();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("just popped " + event.toString());
        }
        return event;
    }

    @Override
    public boolean pushEvent(PropagationEvent event) {
        this.queue.add(event);
        return true;
    }

    @Override
    public void flushEventQueue() {
        if (null != this.lastPopped) {
            this.lastPopped.clear();
        }
        for (PropagationEvent event : this.queue) {
            event.clear();
        }
        this.queue.clear();
    }

    @Override
    public void remove(PropagationEvent event) {
        this.queue.remove(event);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public PropagationEvent get(int idx) {
        for (PropagationEvent event : this.queue) {
            if (idx == 0) {
                return event;
            }
            --idx;
        }
        return null;
    }
}

