/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor.graph;

import choco.cp.solver.preprocessor.graph.ArrayGraph;
import java.util.Random;

public class MaxCliques {
    private ArrayGraph graph;
    private int[][] cliques;

    public MaxCliques(ArrayGraph g) {
        this.graph = g;
        this.computeCliques();
    }

    public void computeCliques() {
        this.graph.setNeighbours();
        boolean[] cand = new boolean[this.graph.nbNode];
        boolean[] K = new boolean[this.graph.nbNode];
        boolean[] gammaK = new boolean[this.graph.nbNode];
        int[] degrees = this.graph.degrees();
        boolean empty = true;
        for (int i = 0; i < this.graph.nbNode; ++i) {
            if (degrees[i] <= 0) continue;
            empty = false;
            cand[i] = true;
            K[i] = false;
            gammaK[i] = true;
        }
        this.cliques = new int[0][0];
        if (!empty) {
            this.BronKerbosh(cand, K, gammaK);
        }
    }

    private boolean BronKerbosh(boolean[] cand, boolean[] K, boolean[] gammaK) {
        boolean b;
        int x = this.getAndRemoveMaxCand(cand);
        boolean[] updatedCand = this.removeNeighbours(x, cand);
        if (!MaxCliques.empty(updatedCand) && !(b = this.BronKerbosh(updatedCand, (boolean[])K.clone(), (boolean[])gammaK.clone()))) {
            return false;
        }
        K[x] = true;
        boolean[] updatedGammaK = this.updateGammaK(x, gammaK);
        if (!MaxCliques.empty(updatedGammaK)) {
            return this.BronKerbosh(updatedGammaK, K, updatedGammaK);
        }
        this.cliques = this.storeCliques(K);
        return this.cliques.length <= 2000;
    }

    private static boolean empty(boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            return false;
        }
        return true;
    }

    private int getAndRemoveMaxCand(boolean[] cand) {
        int index = -1;
        if (!MaxCliques.empty(cand)) {
            int max = 0;
            int[] degrees = this.graph.degrees();
            for (int i = 0; i < cand.length; ++i) {
                if (degrees[i] <= max || !cand[i]) continue;
                max = degrees[i];
                index = i;
            }
            cand[index] = false;
        }
        return index;
    }

    private boolean[] removeNeighbours(int x, boolean[] cand) {
        boolean[] res = (boolean[])cand.clone();
        int[] neighbours = this.graph.neighbours(x);
        for (int i = 0; i < neighbours.length; ++i) {
            res[neighbours[i]] = false;
        }
        return res;
    }

    private boolean[] updateGammaK(int x, boolean[] gammaK) {
        boolean[] res = (boolean[])gammaK.clone();
        for (int i = 0; i < gammaK.length; ++i) {
            boolean isIn;
            if (!res[i] || (isIn = this.graph.isIn(x, i))) continue;
            res[i] = false;
        }
        res[x] = false;
        return res;
    }

    private int[][] storeCliques(boolean[] K) {
        int[][] updated = new int[this.cliques.length + 1][];
        for (int i = 0; i < updated.length - 1; ++i) {
            updated[i] = this.cliques[i];
        }
        int size = 0;
        for (int i = 0; i < K.length; ++i) {
            if (!K[i]) continue;
            ++size;
        }
        updated[updated.length - 1] = new int[size];
        int index = 0;
        for (int i = 0; i < K.length; ++i) {
            if (!K[i]) continue;
            updated[updated.length - 1][index] = i;
            ++index;
        }
        return updated;
    }

    public int[][] getMaxCliques() {
        return this.cliques;
    }

    public static String display(int[] array) {
        String s = "[";
        for (int i = 0; i < array.length; ++i) {
            s = s + array[i];
            if (i >= array.length - 1) continue;
            s = s + ",";
        }
        s = s + "]";
        return s;
    }

    public static String display(int[][] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            s = s + MaxCliques.display(array[i]);
            s = s + "\n";
        }
        return s;
    }

    public static ArrayGraph generateGraph(int n, int m, int seed, double start) {
        System.out.print("Generating graph... ");
        ArrayGraph g = new ArrayGraph(n);
        if (m > n * (n + 1) / 2) {
            m = n * (n + 1) / 2;
        }
        Random r = new Random(seed);
        for (int i = 0; i < m; ++i) {
            int v1 = Math.abs(r.nextInt()) % g.nbNode;
            int v2 = Math.abs(r.nextInt()) % g.nbNode;
            while (v1 == v2 || g.isIn(v1, v2)) {
                v1 = Math.abs(r.nextInt()) % g.nbNode;
                v2 = Math.abs(r.nextInt()) % g.nbNode;
            }
            g.addEdge(v1, v2);
        }
        System.out.println("done (" + ((double)System.currentTimeMillis() - start) + " ms).\n");
        System.out.flush();
        return g;
    }

    public static void test(int n, int m, int seed) {
        double start = System.currentTimeMillis();
        ArrayGraph g = MaxCliques.generateGraph(n, m, seed, start);
        MaxCliques myCliques = new MaxCliques(g);
        System.out.println("cliques : \n" + MaxCliques.display(myCliques.getMaxCliques()));
        System.out.println("Total time : " + ((double)System.currentTimeMillis() - start) + " ms.\n");
        if (n <= 16) {
            System.out.println(g);
        }
    }

    public static void testEmptyGraph241108() {
        System.out.println("Graph without edges");
        MaxCliques.test(6, 0, 1986);
    }

    public static void main(String[] args) {
        int n = 6;
        int m = 10;
        int seed = 1986;
        if (args.length >= 1) {
            n = Integer.parseInt(args[0]);
            if (args.length >= 2) {
                m = Integer.parseInt(args[1]);
                if (args.length >= 3) {
                    seed = Integer.parseInt(args[2]);
                }
            }
        }
        MaxCliques.test(n, m, seed);
        MaxCliques.testEmptyGraph241108();
    }
}

