/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor.graph;

import choco.cp.model.CPModel;
import choco.kernel.model.constraints.Constraint;
import java.util.BitSet;
import java.util.HashMap;

public class ArrayGraph {
    private BitSet[] mat;
    private int[][] adjmat;
    public int nbNode;
    public int nbEdges = 0;
    public HashMap<Edge, Constraint> storeEdges;

    public ArrayGraph(int n) {
        this.mat = new BitSet[n];
        this.adjmat = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.mat[i] = new BitSet(n);
        }
        this.nbNode = n;
        this.storeEdges = new HashMap();
    }

    public void addEdge(int i, int j) {
        if (!this.mat[i].get(j)) {
            ++this.nbEdges;
        }
        if (!this.mat[j].get(i)) {
            ++this.nbEdges;
        }
        this.mat[i].set(j);
        this.mat[j].set(i);
    }

    public void setNeighbours() {
        for (int i = 0; i < this.mat.length; ++i) {
            this.adjmat[i] = new int[this.mat[i].cardinality()];
            int index = 0;
            int j = this.mat[i].nextSetBit(0);
            while (j >= 0) {
                this.adjmat[i][index] = j;
                ++index;
                j = this.mat[i].nextSetBit(j + 1);
            }
        }
    }

    public void remEdge(int i, int j) {
        if (this.mat[i].get(j)) {
            --this.nbEdges;
        }
        if (this.mat[j].get(i)) {
            --this.nbEdges;
        }
        this.mat[i].clear(j);
        this.mat[j].clear(i);
    }

    public boolean isIn(int i, int j) {
        return this.mat[i].get(j);
    }

    public int degree(int i) {
        return this.adjmat[i].length;
    }

    public int[] neighbours(int i) {
        return this.adjmat[i];
    }

    public int[] degrees() {
        int[] res = new int[this.mat.length];
        for (int i = 0; i < this.mat.length; ++i) {
            res[i] = this.degree(i);
        }
        return res;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.mat.length; ++i) {
            for (int j = 0; j < this.mat.length; ++j) {
                s = this.mat[i].get(j) ? s + "x " : s + ". ";
            }
            s = s + "\n";
        }
        return s;
    }

    public void storeEdge(Constraint c, int a, int b) {
        this.storeEdges.put(new Edge(a, b), c);
    }

    public void deleteConstraintEdge(CPModel mod, int a, int b) {
        Constraint c = this.storeEdges.get(new Edge(a, b));
        Constraint c2 = this.storeEdges.get(new Edge(b, a));
        if (c != null) {
            mod.removeConstraint(c);
        } else if (c2 != null) {
            mod.removeConstraint(c2);
        }
    }

    public static class Edge {
        int a;
        int b;

        public Edge(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            return this.a * 10000000 + this.b;
        }

        public boolean equals(Object obj) {
            return ((Edge)obj).a == this.a && ((Edge)obj).b == this.b;
        }
    }
}

