/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor.detectors;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.DistanceXYC;
import choco.cp.solver.constraints.integer.DistanceXYZ;
import choco.cp.solver.constraints.integer.MaxOfAList;
import choco.cp.solver.constraints.integer.MinOfAList;
import choco.cp.solver.constraints.integer.SignOp;
import choco.cp.solver.constraints.integer.TimesXYZ;
import choco.cp.solver.constraints.integer.bool.BoolTimesXYZ;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.constraints.reified.leaves.ConstantLeaf;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class ExpressionDetector {
    public SConstraint getIntentionalConstraint(ExpressionSConstraint e, CPSolver s) {
        SConstraint ct = null;
        ct = this.getSignConstraint(e, s);
        if (ct != null) {
            return ct;
        }
        ct = this.getScalarConstraint(e, s);
        if (ct != null) {
            return ct;
        }
        ct = this.getMinMaxConstraint(e, s);
        if (ct != null) {
            return ct;
        }
        ct = this.getMultConstraint(e, s);
        if (ct != null) {
            return ct;
        }
        ct = this.getDistanceConstraint(e, s);
        if (ct != null) {
            return ct;
        }
        return ct;
    }

    public SConstraint getScalarConstraint(ExpressionSConstraint e, CPSolver s) {
        INode expr = e.getRootNode();
        if (this.isAScalar(expr)) {
            IntDomainVar[] scope = e.getVars();
            INode right = expr.getSubtree(1);
            INode left = expr.getSubtree(0);
            int[] c1 = left.computeLinearExpr(scope.length);
            int[] c2 = right.computeLinearExpr(scope.length);
            int[] coefs = new int[scope.length];
            for (int i = 0; i < coefs.length; ++i) {
                coefs[i] = c1[i] - c2[i];
            }
            int cste = c2[scope.length] - c1[scope.length];
            if (expr.getType().equals((Object)NodeType.GT)) {
                return s.gt(s.scalar(coefs, scope), cste);
            }
            if (expr.getType().equals((Object)NodeType.LT)) {
                return s.lt(s.scalar(coefs, scope), cste);
            }
            if (expr.getType().equals((Object)NodeType.GEQ)) {
                return s.geq(s.scalar(coefs, scope), cste);
            }
            if (expr.getType().equals((Object)NodeType.LEQ)) {
                return s.leq(s.scalar(coefs, scope), cste);
            }
            if (expr.getType().equals((Object)NodeType.EQ)) {
                return s.eq(s.scalar(coefs, scope), cste);
            }
            if (expr.getType().equals((Object)NodeType.NEQ)) {
                return s.neq(s.scalar(coefs, scope), cste);
            }
            return null;
        }
        return null;
    }

    public boolean isAScalar(INode expr) {
        boolean b;
        boolean bl = b = expr.getType().equals((Object)NodeType.GEQ) || expr.getType().equals((Object)NodeType.GT) || expr.getType().equals((Object)NodeType.LEQ) || expr.getType().equals((Object)NodeType.LT) || expr.getType().equals((Object)NodeType.EQ) || expr.getType().equals((Object)NodeType.NEQ);
        if (b) {
            INode right = expr.getSubtree(0);
            INode left = expr.getSubtree(1);
            return right.isALinearTerm() && left.isALinearTerm();
        }
        return false;
    }

    public SConstraint getSignConstraint(ExpressionSConstraint e, CPSolver s) {
        IntDomainVar[] scope = e.getVars();
        INode expr = e.getRootNode();
        if (scope.length == 2 && scope[0].canBeInstantiatedTo(0) || scope[0].canBeInstantiatedTo(0)) {
            return null;
        }
        if (expr.getType().equals((Object)NodeType.GEQ)) {
            if (this.testXMultYAndCste(expr, 0, 1, 0) || this.testXMultYAndCste(expr, 0, 1, 1)) {
                return new SignOp(scope[0], scope[1], true);
            }
            if (this.testXMultYAndCste(expr, 1, 0, 0) || this.testXMultYAndCste(expr, 1, 0, -1)) {
                return new SignOp(scope[0], scope[1], false);
            }
            return null;
        }
        if (expr.getType().equals((Object)NodeType.GT)) {
            if (this.testXMultYAndCste(expr, 0, 1, 0) || this.testXMultYAndCste(expr, 0, 1, -1)) {
                return new SignOp(scope[0], scope[1], true);
            }
            if (this.testXMultYAndCste(expr, 1, 0, 1) || this.testXMultYAndCste(expr, 1, 0, 0)) {
                return new SignOp(scope[0], scope[1], false);
            }
            return null;
        }
        if (expr.getType().equals((Object)NodeType.LEQ)) {
            if (this.testXMultYAndCste(expr, 1, 0, 0) || this.testXMultYAndCste(expr, 1, 0, 1)) {
                return new SignOp(scope[0], scope[1], true);
            }
            if (this.testXMultYAndCste(expr, 0, 1, 0) || this.testXMultYAndCste(expr, 0, 1, -1)) {
                return new SignOp(scope[0], scope[1], false);
            }
            return null;
        }
        if (expr.getType().equals((Object)NodeType.LT)) {
            if (this.testXMultYAndCste(expr, 1, 0, 0) || this.testXMultYAndCste(expr, 1, 0, -1)) {
                return new SignOp(scope[0], scope[1], true);
            }
            if (this.testXMultYAndCste(expr, 0, 1, 1) || this.testXMultYAndCste(expr, 0, 1, 0)) {
                return new SignOp(scope[0], scope[1], false);
            }
            return null;
        }
        return null;
    }

    public boolean testXMultYAndCste(INode expr, int first, int second, int c) {
        return expr.getNbSubTrees() == 2 && expr.getSubtree(first).getType().equals((Object)NodeType.MULT) && expr.getSubtree(first).hasOnlyVariablesLeaves() && expr.getSubtree(second).isCsteEqualTo(c);
    }

    public SConstraint getMinMaxConstraint(ExpressionSConstraint e, CPSolver s) {
        INode expr = e.getRootNode();
        if (expr.getType().equals((Object)NodeType.EQ)) {
            if (this.isMin(expr, 0, 1)) {
                IntDomainVar[] tmpVars = new IntDomainVar[expr.getSubtree(0).getScope(s).length + 1];
                tmpVars[0] = expr.getSubtree(1).getScope(s)[0];
                System.arraycopy(expr.getSubtree(0).getScope(s), 0, tmpVars, 1, expr.getSubtree(0).getScope(s).length);
                return new MinOfAList(tmpVars);
            }
            if (this.isMin(expr, 1, 0)) {
                IntDomainVar[] tmpVars = new IntDomainVar[expr.getSubtree(1).getScope(s).length + 1];
                tmpVars[0] = expr.getSubtree(0).getScope(s)[0];
                System.arraycopy(expr.getSubtree(1).getScope(s), 0, tmpVars, 1, expr.getSubtree(1).getScope(s).length);
                return new MinOfAList(tmpVars);
            }
            if (this.isMax(expr, 0, 1)) {
                IntDomainVar[] tmpVars = new IntDomainVar[expr.getSubtree(0).getScope(s).length + 1];
                tmpVars[0] = expr.getSubtree(1).getScope(s)[0];
                System.arraycopy(expr.getSubtree(0).getScope(s), 0, tmpVars, 1, expr.getSubtree(0).getScope(s).length);
                return new MaxOfAList(tmpVars);
            }
            if (this.isMax(expr, 1, 0)) {
                IntDomainVar[] tmpVars = new IntDomainVar[expr.getSubtree(1).getScope(s).length + 1];
                tmpVars[0] = expr.getSubtree(0).getScope(s)[0];
                System.arraycopy(expr.getSubtree(1).getScope(s), 0, tmpVars, 1, expr.getSubtree(1).getScope(s).length);
                return new MaxOfAList(tmpVars);
            }
        }
        return null;
    }

    public boolean isMin(INode expr, int first, int second) {
        return expr.getSubtree(first).getType().equals((Object)NodeType.MIN) && expr.getSubtree(first).hasOnlyVariablesLeaves() && expr.getSubtree(second).isAVariable();
    }

    public boolean isMax(INode expr, int first, int second) {
        return expr.getSubtree(first).getType().equals((Object)NodeType.MAX) && expr.getSubtree(first).hasOnlyVariablesLeaves() && expr.getSubtree(second).isAVariable();
    }

    public SConstraint getMultConstraint(ExpressionSConstraint e, CPSolver s) {
        INode expr = e.getRootNode();
        if (expr.getType().equals((Object)NodeType.EQ)) {
            IntDomainVar[] vs = null;
            if (this.isMult(expr, 0, 1)) {
                vs = new IntDomainVar[]{expr.getSubtree(0).getScope(s)[0], expr.getSubtree(0).getScope(s)[1], expr.getSubtree(1).getScope(s)[0]};
            } else if (this.isMult(expr, 1, 0)) {
                vs = new IntDomainVar[3];
                vs[2] = expr.getSubtree(0).getScope(s)[0];
                vs[0] = expr.getSubtree(1).getScope(s)[0];
                vs[1] = expr.getSubtree(1).getScope(s)[1];
            }
            if (vs != null) {
                if (vs[0].hasBooleanDomain() && vs[1].hasBooleanDomain() && vs[2].hasBooleanDomain()) {
                    return new BoolTimesXYZ(vs[0], vs[1], vs[2]);
                }
                return new TimesXYZ(vs[0], vs[1], vs[2]);
            }
        }
        return null;
    }

    public boolean isMult(INode expr, int first, int second) {
        return expr.getSubtree(first).getType().equals((Object)NodeType.MULT) && expr.getSubtree(first).hasOnlyVariablesLeaves() && expr.getSubtree(second).isAVariable();
    }

    public SConstraint getDistanceConstraint(ExpressionSConstraint e, CPSolver s) {
        INode expr = e.getRootNode();
        IntDomainVar x = null;
        IntDomainVar y = null;
        IntDomainVar z = null;
        int dist = -1;
        if (expr.getNbSubTrees() == 2) {
            boolean b1 = this.isDistance(expr, 0, 1);
            boolean b2 = this.isDistance(expr, 1, 0);
            if (b1 || b2) {
                int idx1 = b1 ? 0 : 1;
                int idx2 = b1 ? 1 : 0;
                x = expr.getSubtree(idx1).getSubtree(0).getSubtree(0).getScope(s)[0];
                y = expr.getSubtree(idx1).getSubtree(0).getSubtree(1).getScope(s)[0];
                if (expr.getSubtree(idx2).isAConstant()) {
                    dist = ((ConstantLeaf)expr.getSubtree(idx2)).getConstant();
                } else {
                    z = expr.getSubtree(idx2).getScope(s)[0];
                }
            } else {
                return null;
            }
            if (expr.getType().equals((Object)NodeType.EQ)) {
                if (z == null) {
                    return new DistanceXYC(x, y, dist, 0);
                }
                return new DistanceXYZ(x, y, z, 0, 0);
            }
            if (expr.getType().equals((Object)NodeType.LT)) {
                if (z == null) {
                    return new DistanceXYC(x, y, dist, 1);
                }
                return new DistanceXYZ(x, y, z, 0, 1);
            }
            if (expr.getType().equals((Object)NodeType.GT)) {
                if (z == null) {
                    return new DistanceXYC(x, y, dist, 2);
                }
                return new DistanceXYZ(x, y, z, 0, 2);
            }
            if (expr.getType().equals((Object)NodeType.LEQ)) {
                if (z == null) {
                    return new DistanceXYC(x, y, dist + 1, 1);
                }
                return new DistanceXYZ(x, y, z, 1, 1);
            }
            if (expr.getType().equals((Object)NodeType.GEQ)) {
                if (z == null) {
                    return new DistanceXYC(x, y, dist - 1, 2);
                }
                return new DistanceXYZ(x, y, z, -1, 2);
            }
            if (expr.getType().equals((Object)NodeType.NEQ)) {
                if (z == null) {
                    return new DistanceXYC(x, y, dist, 3);
                }
                return null;
            }
        }
        return null;
    }

    public boolean isDistance(INode expr, int first, int second) {
        INode i1 = expr.getSubtree(first);
        if (i1.getNbSubTrees() == 1) {
            INode i11 = i1.getSubtree(0);
            INode i2 = expr.getSubtree(second);
            return (i2.isAVariable() || i2.isAConstant()) && i11.hasOnlyVariablesLeaves() && i11.getType().equals((Object)NodeType.MINUS) && i1.getType().equals((Object)NodeType.ABS);
        }
        return false;
    }

    public SimplePrecedence getPrecedenceConstraint(ExpressionSConstraint e) {
        INode expr = e.getRootNode();
        INode i1 = expr.getSubtree(0);
        if (i1.getNbSubTrees() == 2 && expr.getType().equals((Object)NodeType.OR)) {
            INode left = expr.getSubtree(0);
            INode right = expr.getSubtree(1);
            if (left.getType().equals((Object)NodeType.LEQ) && right.getType().equals((Object)NodeType.LEQ)) {
                INode l1 = left.getSubtree(0);
                INode l2 = left.getSubtree(1);
                INode r1 = right.getSubtree(0);
                INode r2 = right.getSubtree(1);
                if (l2.isAVariable() && r2.isAVariable() && this.isPlusVarCste(l1) && this.isPlusVarCste(r1)) {
                    int d1 = this.getConstant(l1);
                    IntegerVariable v1 = r2.getModelScope()[0];
                    int d2 = this.getConstant(r1);
                    IntegerVariable v2 = l2.getModelScope()[0];
                    return new SimplePrecedence(v1, d1, v2, d2);
                }
            }
        }
        return null;
    }

    public boolean isPlusVarCste(INode plus) {
        return plus.getType().equals((Object)NodeType.PLUS) && plus.countNbVar() == 1 && (plus.getSubtree(0).isAVariable() || plus.getSubtree(1).isAVariable());
    }

    public int getConstant(INode plus) {
        INode in = plus.getSubtree(0);
        INode in2 = plus.getSubtree(1);
        if (in.countNbVar() == 0) {
            return ((ArithmNode)((Object)in)).eval(null);
        }
        return ((ArithmNode)((Object)in2)).eval(null);
    }

    public boolean encompassDiff(ExpressionSConstraint ic) {
        if (ic.getNbVars() != 2) {
            return false;
        }
        IntDomainVar v1 = ic.getVars()[0];
        IntDomainVar v2 = ic.getVars()[1];
        if (v2.getDomainSize() < v1.getDomainSize()) {
            IntDomainVar temp = v1;
            v1 = v2;
            v2 = temp;
        }
        if (v1.getDomainSize() <= 100 && v2.getDomainSize() <= 100) {
            DisposableIntIterator it = v1.getDomain().getIterator();
            while (it.hasNext()) {
                int val = it.next();
                if (!v2.canBeInstantiatedTo(val) || !ic.checkCouple(val, val)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasHolesWithinOneDomain(ExpressionSConstraint e) {
        IntDomainVar[] vs = e.getVars();
        for (int i = 0; i < vs.length; ++i) {
            IntDomainVar v = vs[i];
            int span = v.getSup() - v.getInf() + 1;
            if (!(PreProcessCPSolver.ratioHole * (float)span > (float)v.getDomainSize())) continue;
            return true;
        }
        return false;
    }

    public boolean toBeDecomposed(ExpressionSConstraint e) {
        boolean isDecompPossible = e.checkDecompositionIsPossible();
        int arity = e.getNbVars();
        double cardProd = e.cardProd();
        return isDecompPossible && (arity >= 6 || arity >= 4 && cardProd >= 2000.0 || arity >= 3 && cardProd >= 50000.0);
    }

    public boolean isVeryBinaryHeavy(ExpressionSConstraint e) {
        if (e.getNbVars() == 2) {
            IntDomainVar v1 = e.getVars()[0];
            IntDomainVar v2 = e.getVars()[1];
            int maxspan = Math.max(v1.getSup() - v1.getInf() + 1, v2.getSup() - v2.getInf() + 1);
            int maxdsize = Math.max(v1.getDomainSize(), v2.getDomainSize());
            return maxspan >= 1000 && maxdsize < maxspan;
        }
        return false;
    }

    public static class SimplePrecedence {
        public int d1;
        public int d2;
        public IntegerVariable v1;
        public IntegerVariable v2;

        public SimplePrecedence(IntegerVariable v1, int d1, IntegerVariable v2, int d2) {
            this.v1 = v1;
            this.v2 = v2;
            this.d1 = d1;
            this.d2 = d2;
        }
    }
}

