/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor.detectors;

import choco.cp.model.CPModel;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.cp.solver.preprocessor.detectors.ExpressionDetector;
import choco.cp.solver.preprocessor.graph.ArrayGraph;
import choco.cp.solver.preprocessor.graph.MaxCliques;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.Arrays;
import java.util.Iterator;

public class CliqueDetector {
    protected ArrayGraph diffs;
    protected CliqueIterator itc;
    protected CPModel mod;

    public CliqueDetector(CPModel mod) {
        this.diffs = new ArrayGraph(mod.getNbIntVars());
        this.mod = mod;
    }

    public void addEdge(Variable a, Variable b, Constraint c) {
        int idxa = (Integer)((IntegerVariable)a).getHook();
        int idxb = (Integer)((IntegerVariable)b).getHook();
        this.diffs.addEdge(idxa, idxb);
        this.diffs.storeEdge(c, idxa, idxb);
    }

    public void removeConstraint(int a, int b) {
        this.diffs.deleteConstraintEdge(this.mod, a, b);
    }

    public boolean addAllNeqEdges() {
        Iterator<Constraint> itneq = this.mod.getConstraintByType(ConstraintType.NEQ);
        while (itneq.hasNext()) {
            Constraint neq = itneq.next();
            Variable[] vars = neq.getVariables();
            if (!this.isRealBinaryNeq(vars)) continue;
            this.addEdge(neq.getVariables()[0], neq.getVariables()[1], neq);
        }
        return this.diffs.nbEdges > 0;
    }

    public boolean isRealBinaryNeq(Variable[] vars) {
        if (vars.length != 2) {
            return false;
        }
        for (Variable var : vars) {
            if (var.getVariableType() == VariableType.INTEGER) continue;
            return false;
        }
        return true;
    }

    public int[] addAllDisjunctiveEdges(ExpressionDetector ed, PreProcessCPSolver ppcs) {
        Iterator<Constraint> it = this.mod.getConstraintIterator();
        int[] durations = new int[this.mod.getNbIntVars()];
        Arrays.fill(durations, -1);
        boolean b = false;
        while (it.hasNext()) {
            ExpressionSConstraint es;
            ExpressionDetector.SimplePrecedence sp;
            Constraint ic = it.next();
            if (!(ic instanceof MetaConstraint) || (sp = ed.getPrecedenceConstraint(es = new ExpressionSConstraint(ppcs.getMod2Sol().buildNode(ic)))) == null) continue;
            b = true;
            this.addEdge(sp.v1, sp.v2, ic);
            int idx1 = (Integer)sp.v1.getHook();
            int idx2 = (Integer)sp.v2.getHook();
            if (durations[idx1] == -1) {
                durations[idx1] = sp.d1;
            } else if (durations[idx1] != sp.d1) {
                return null;
            }
            if (durations[idx2] == -1) {
                durations[idx2] = sp.d2;
                continue;
            }
            if (durations[idx2] == sp.d2) continue;
            return null;
        }
        if (b) {
            return durations;
        }
        return null;
    }

    public CliqueIterator cliqueIterator() {
        if (this.itc == null) {
            return new CliqueIterator();
        }
        this.itc.init();
        return this.itc;
    }

    public class CliqueIterator
    implements Iterator<IntegerVariable[]> {
        protected int idx = 0;
        protected int[][] clique;

        public CliqueIterator() {
            MaxCliques mc = new MaxCliques(CliqueDetector.this.diffs);
            this.clique = mc.getMaxCliques();
        }

        public void init() {
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.clique.length;
        }

        @Override
        public IntegerVariable[] next() {
            IntegerVariable[] c = new IntegerVariable[this.clique[this.idx].length];
            for (int j = 0; j < c.length; ++j) {
                c[j] = CliqueDetector.this.mod.getIntVar(this.clique[this.idx][j]);
            }
            ++this.idx;
            return c;
        }

        @Override
        public void remove() {
            int id = this.idx - 1;
            for (int j = 0; j < this.clique[id].length; ++j) {
                for (int k = j + 1; k < this.clique[id].length; ++k) {
                    CliqueDetector.this.diffs.remEdge(this.clique[id][j], this.clique[id][k]);
                    CliqueDetector.this.removeConstraint(this.clique[id][j], this.clique[id][k]);
                }
            }
        }
    }
}

