/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.kernel.common.util.IntIterator;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.Iterator;

public class SymBreaking {
    protected IntegerVariable[] maxclique = null;

    public void setMaxClique(IntegerVariable[] clique) {
        if (this.maxclique == null || this.maxclique.length < clique.length) {
            this.maxclique = clique;
        }
    }

    public void addSymBreakingConstraint(CPModel m) {
        if (this.maxclique != null && this.checkOnlyOneDomain(m) && this.checkOnlyDiff(m)) {
            IntIterator it = m.getIntVar(0).getDomainIterator();
            for (int i = 0; i < this.maxclique.length && it.hasNext(); ++i) {
                m.addConstraint(Choco.eq((IntegerExpressionVariable)this.maxclique[i], it.next()));
            }
        }
    }

    public boolean checkOnlyOneDomain(CPModel m) {
        Iterator it = m.getIntVarIterator();
        if (it.hasNext()) {
            IntegerVariable v = (IntegerVariable)it.next();
            int lb = v.getLowB();
            int ub = v.getUppB();
            if (v.getValues() != null) {
                return false;
            }
            while (it.hasNext()) {
                IntegerVariable v2 = (IntegerVariable)it.next();
                if (v2.getLowB() == lb && v2.getUppB() == ub && v2.getValues() == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkOnlyDiff(CPModel m) {
        Iterator<Constraint> it = m.getConstraintIterator();
        while (it.hasNext()) {
            Constraint ct = it.next();
            if (ct.getConstraintType() == ConstraintType.NEQ || ct.getConstraintType() == ConstraintType.ALLDIFFERENT) continue;
            return false;
        }
        return true;
    }
}

