/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.preprocessor.PPModelToCPSolver;
import choco.cp.solver.preprocessor.PPSearch;
import choco.cp.solver.preprocessor.SymBreaking;
import choco.cp.solver.preprocessor.detectors.CliqueDetector;
import choco.cp.solver.preprocessor.detectors.ExpressionDetector;
import choco.cp.solver.preprocessor.detectors.RelationDetector;
import choco.cp.solver.preprocessor.graph.ArrayGraph;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.AbstractConstraint;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import parser.chocogen.XmlModel;

public class PreProcessCPSolver
extends CPSolver {
    protected HashSet<String> options;
    protected ExpressionDetector cleverExp;
    protected RelationDetector cleverRel;
    protected SymBreaking symb;
    protected PPSearch ppsearch;
    public static float ratioHole = 0.7f;
    public int proptime;
    public boolean restartMode = false;

    public PreProcessCPSolver() {
        this.init();
    }

    public PreProcessCPSolver(IEnvironment env) {
        super(env);
        this.init();
    }

    public void init() {
        this.cleverExp = new ExpressionDetector();
        this.cleverRel = new RelationDetector();
        this.symb = new SymBreaking();
        this.options = new HashSet();
        this.mod2sol = new PPModelToCPSolver(this);
        this.ppsearch = new PPSearch();
    }

    public PPModelToCPSolver getMod2Sol() {
        return (PPModelToCPSolver)this.mod2sol;
    }

    public void addOption(String opt) {
        this.options.add(opt);
    }

    public void addOptions(String options) {
        if (options != null && !"".equals(options)) {
            String[] optionsStrings;
            for (String optionsString : optionsStrings = options.split(" ")) {
                this.addOption(optionsString);
            }
        }
    }

    public void setAllProcessing() {
        this.options.add("bb:exp");
        this.options.add("bb:cliques");
        this.options.add("bb:exttoint");
        this.options.add("bb:disjunctive");
        this.options.add("bb:breaksym");
    }

    public void associateIndexes(Model m) {
        Iterator<IntegerVariable> it = m.getIntVarIterator();
        int cpt = 0;
        while (it.hasNext()) {
            IntegerVariable iv = it.next();
            iv.setHook(cpt);
            ++cpt;
        }
    }

    @Override
    public void read(Model m) {
        this.model = (CPModel)m;
        this.ppsearch.setModel(this.model);
        super.initReading();
        this.setAllProcessing();
        this.associateIndexes(m);
        this.detectEqualities(m);
        this.mod2sol.readVariables(this.model);
        if (this.options.contains("bb:disjunctive")) {
            this.detectDisjonctives(m);
        }
        if (this.options.contains("bb:exp")) {
            this.detectExpression(m);
        }
        if (this.options.contains("bb:cliques")) {
            this.detectCliques(m);
        }
        this.mod2sol.readVariables(this.model);
        if (this.options.contains("bb:breaksym")) {
            this.breakSymetries(m);
        }
        this.getMod2Sol().readBBDecisionVariables();
        this.getMod2Sol().readConstraints(this.model);
    }

    public boolean setVersatile(CPSolver s, int inittime) {
        return this.ppsearch.setVersatile(s, inittime);
    }

    public boolean setDomOverDeg(CPSolver s) {
        return this.ppsearch.setDomOverDeg(s);
    }

    public boolean setDomOverWeg(CPSolver s, int inittime) {
        return this.ppsearch.setDomOverWeg(s, inittime);
    }

    public boolean setImpact(CPSolver s, int initialisationtime) {
        return this.ppsearch.setImpact(s, initialisationtime);
    }

    public boolean isScheduling() {
        if (this.model == null) {
            throw new SolverException("you must read the model before !");
        }
        return this.ppsearch.isScheduling();
    }

    public boolean isExtensionnal() {
        if (this.model == null) {
            throw new SolverException("you must read the model before !");
        }
        return this.model.getNbConstraintByType(ConstraintType.TABLE) > 0;
    }

    public boolean isBinaryExtensionnal() {
        if (this.model == null) {
            throw new SolverException("you must read the model before !");
        }
        if (this.model.getNbConstraintByType(ConstraintType.TABLE) == 0) {
            return false;
        }
        Iterator<Constraint> it = this.model.getConstraintIterator();
        while (it.hasNext()) {
            Constraint ct = it.next();
            if (ct.getNbVars() <= 2) continue;
            return false;
        }
        return true;
    }

    public PPSearch getBBSearch() {
        return this.ppsearch;
    }

    public void breakSymetries(Model m) {
        this.symb.addSymBreakingConstraint((CPModel)m);
    }

    public boolean isAValidExpression(Constraint ic) {
        return ic instanceof MetaConstraint || ic instanceof ComponentConstraint && (ic.getConstraintType() == ConstraintType.EQ || ic.getConstraintType() == ConstraintType.NEQ || ic.getConstraintType() == ConstraintType.LEQ || ic.getConstraintType() == ConstraintType.GEQ || ic.getConstraintType() == ConstraintType.GT || ic.getConstraintType() == ConstraintType.LT);
    }

    public void detectExpression(Model m) {
        Iterator<Constraint> it = m.getConstraintIterator();
        LinkedList<Constraint> neqToAdd = new LinkedList<Constraint>();
        while (it.hasNext()) {
            Constraint ic = it.next();
            if (this.mapconstraints.containsKey(ic.getIndexIn(m.getIndex())) || !this.isAValidExpression(ic)) continue;
            ExpressionSConstraint c = new ExpressionSConstraint(this.getMod2Sol().buildNode(ic));
            c.setScope(this);
            this.getMod2Sol().storeExpressionSConstraint(ic, c);
            SConstraint intensional = this.cleverExp.getIntentionalConstraint(c, this);
            if (intensional != null) {
                c.setKnownIntensionalConstraint(intensional);
                continue;
            }
            if (!this.cleverExp.encompassDiff(c)) continue;
            IntegerVariable[] vars = ((AbstractConstraint)ic).getIntVariableScope();
            neqToAdd.add(Choco.neq((IntegerExpressionVariable)vars[0], (IntegerExpressionVariable)vars[1]));
        }
        for (Constraint aNeqToAdd : neqToAdd) {
            m.addConstraint(aNeqToAdd);
        }
    }

    public void detectCliques(Model m) {
        CliqueDetector cdetect = new CliqueDetector((CPModel)m);
        if (cdetect.addAllNeqEdges()) {
            CliqueDetector.CliqueIterator it = cdetect.cliqueIterator();
            while (it.hasNext()) {
                IntegerVariable[] cl = it.next();
                if (cl.length > 2) {
                    m.addConstraint(Choco.allDifferent(cl));
                    this.symb.setMaxClique(cl);
                    it.remove();
                    continue;
                }
                m.addConstraint(Choco.neq((IntegerExpressionVariable)cl[0], (IntegerExpressionVariable)cl[1]));
            }
        }
    }

    public int[] getVarIndexes(IntegerVariable[] vs) {
        int[] idxs = new int[vs.length];
        for (int i = 0; i < idxs.length; ++i) {
            idxs[i] = (Integer)vs[i].getHook();
        }
        return idxs;
    }

    public void detectDisjonctives(Model m) {
        CliqueDetector cdetect = new CliqueDetector((CPModel)m);
        int[] durations = cdetect.addAllDisjunctiveEdges(this.cleverExp, this);
        if (durations != null) {
            BitSet[] precedenceAlreadyAdded = new BitSet[m.getNbIntVars()];
            for (int i = 0; i < m.getNbIntVars(); ++i) {
                precedenceAlreadyAdded[i] = new BitSet();
            }
            CliqueDetector.CliqueIterator it = cdetect.cliqueIterator();
            while (it.hasNext()) {
                IntegerVariable[] cl = it.next();
                int[] idxs = this.getVarIndexes(cl);
                int[] dur = new int[cl.length];
                TaskVariable[] tasks = new TaskVariable[cl.length];
                for (int i = 0; i < cl.length; ++i) {
                    dur[i] = durations[idxs[i]];
                    tasks[i] = Choco.makeTaskVar("", cl[i], (IntegerVariable)Choco.constant(dur[i]), new String[0]);
                }
                for (int j = 0; j < cl.length; ++j) {
                    for (int k = j + 1; k < cl.length; ++k) {
                        if (precedenceAlreadyAdded[idxs[j]].get(idxs[k])) continue;
                        IntegerVariable b = Choco.makeIntVar("" + (dur[j] + dur[k]), 0, 1, new String[0]);
                        m.addConstraint(Choco.preceding(cl[j], dur[j], cl[k], dur[k], b));
                        precedenceAlreadyAdded[idxs[j]].set(idxs[k]);
                        precedenceAlreadyAdded[idxs[k]].set(idxs[j]);
                    }
                }
                m.addConstraint(Choco.disjunctive(tasks, new String[0]));
                it.remove();
            }
        }
    }

    private void detectEqualities(Model m) {
        int n = m.getNbIntVars();
        ArrayGraph eqGraph = new ArrayGraph(n);
        Iterator<Constraint> iteq = m.getConstraintByType(ConstraintType.EQ);
        while (iteq.hasNext()) {
            Constraint c = iteq.next();
            Variable v1 = c.getVariables()[0];
            Variable v2 = c.getVariables()[1];
            if (v1.getVariableType() != VariableType.INTEGER || v2.getVariableType() != VariableType.INTEGER) continue;
            int idxa = (Integer)((IntegerVariable)v1).getHook();
            int idxb = (Integer)((IntegerVariable)v2).getHook();
            eqGraph.addEdge(idxa, idxb);
            this.mapconstraints.put(c.getIndexIn(m.getIndex()), null);
        }
        if (eqGraph.nbEdges > 0) {
            int[] color = new int[n];
            Arrays.fill(color, -1);
            HashMap<Integer, Domain> domainByColor = new HashMap<Integer, Domain>();
            int k = -1;
            Domain dtmp = new Domain();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (color[i] == -1) {
                        color[i] = ++k;
                        domainByColor.put(k, new Domain(m.getIntVar(i)));
                    }
                    if (!eqGraph.isIn(i, j) && !eqGraph.isIn(j, i)) continue;
                    Domain d = (Domain)domainByColor.get(color[i]);
                    dtmp.copy(d);
                    if (d.intersection(m.getIntVar(j))) {
                        color[j] = color[i];
                        domainByColor.put(color[i], d);
                        continue;
                    }
                    m.addConstraint(Choco.eq((IntegerExpressionVariable)m.getIntVar(i), (IntegerExpressionVariable)m.getIntVar(j)));
                    d.copy(dtmp);
                }
            }
            IntDomainVar[] var = new IntDomainVar[k + 1];
            for (int i = 0; i < n; ++i) {
                int col = color[i];
                IntegerVariable v = m.getIntVar(i);
                if (var[col] == null) {
                    dtmp = (Domain)domainByColor.get(col);
                    IntegerVariable vtmp = dtmp.values != null ? new IntegerVariable(v.getName(), VariableType.INTEGER, dtmp.values) : new IntegerVariable(v.getName(), VariableType.INTEGER, dtmp.low, dtmp.upp);
                    vtmp.addOptions(dtmp.options);
                    vtmp.findManager(this.model.properties);
                    var[col] = (IntDomainVar)this.mod2sol.readModelVariable(vtmp);
                }
                this.mapvariables.put(v.getIndexIn(this.model.getIndex()), var[col]);
            }
        }
    }

    public boolean initialPropagation() {
        this.proptime = (int)System.currentTimeMillis();
        try {
            this.propagate();
        }
        catch (ContradictionException e) {
            return false;
        }
        this.proptime = (int)System.currentTimeMillis() - this.proptime;
        this.restartMode = this.proptime <= 300 && !this.isBinaryExtensionnal();
        return true;
    }

    public boolean rootNodeSingleton(int timelimit) {
        if (!XmlModel.doSingleton()) {
            return true;
        }
        boolean sched = this.isScheduling();
        int time = (int)System.currentTimeMillis();
        if (this.proptime <= 1500) {
            int nbvrem = 0;
            int nbvtried = 0;
            int threshold = 100;
            this.worldPush();
            block4: for (int i = 0; i < this.getNbIntVars(); ++i) {
                IntDomainVar v = (IntDomainVar)this.getIntVar(i);
                DisposableIntIterator it = v.getDomain().getIterator();
                if ((!sched || v.getDomainSize() != 2) && (sched || !v.hasEnumeratedDomain())) continue;
                while (it.hasNext()) {
                    int val = it.next();
                    ++nbvtried;
                    boolean cont = false;
                    this.worldPush();
                    try {
                        v.instantiate(val, -1);
                        this.propagate();
                    }
                    catch (ContradictionException e) {
                        cont = true;
                    }
                    this.worldPop();
                    if (cont) {
                        try {
                            ++nbvrem;
                            v.remVal(val);
                            this.propagate();
                        }
                        catch (ContradictionException e) {
                            return false;
                        }
                    }
                    if ((int)(System.currentTimeMillis() - (long)time) <= timelimit && (nbvtried != threshold || nbvrem != 0 || this.proptime < 200)) continue;
                    continue block4;
                }
            }
        }
        return true;
    }

    private static class Domain {
        protected int low;
        protected int upp;
        int[] values;
        HashSet<String> options = new HashSet();

        private Domain() {
        }

        private Domain(IntegerVariable v) {
            this();
            this.low = v.getLowB();
            this.upp = v.getUppB();
            this.options = v.getOptions();
        }

        public void copy(Domain d) {
            this.low = d.low;
            this.upp = d.upp;
            if (d.values != null) {
                this.values = new int[d.values.length];
                System.arraycopy(d.values, 0, this.values, 0, this.values.length);
            }
            this.options = d.options;
        }

        private int[] enumVal() {
            if (this.values != null) {
                if (this.values.length == 2 && this.values[0] == this.values[1]) {
                    return new int[]{this.values[0]};
                }
                return this.values;
            }
            int[] val = new int[this.upp - this.low + 1];
            for (int i = 0; i < val.length; ++i) {
                val[i] = this.low + i;
            }
            return val;
        }

        public boolean intersection(IntegerVariable v) {
            if (v.getValues() == null && this.values == null) {
                this.low = Math.max(this.low, v.getLowB());
                this.upp = Math.min(this.upp, v.getUppB());
                if (this.low > this.upp) {
                    return false;
                }
            } else {
                int[] val = new int[Math.min(this.upp - this.low + 1, v.getDomainSize())];
                int size = 0;
                int[] ev1 = this.enumVal();
                int[] ev2 = v.enumVal();
                for (int anEv1 : ev1) {
                    for (int anEv2 : ev2) {
                        if (anEv1 != anEv2) continue;
                        val[size++] = anEv1;
                    }
                }
                if (size > 0) {
                    this.values = new int[size];
                    System.arraycopy(val, 0, this.values, 0, size--);
                    this.low = this.values[0];
                    this.upp = this.values[size];
                } else {
                    return false;
                }
            }
            HashSet<String> tOptions = new HashSet<String>();
            if (v.getOptions().contains("cp:decision") || this.options.contains("cp:decision")) {
                tOptions.add("cp:decision");
            }
            if (v.getOptions().contains("cp:objective") || this.options.contains("cp:objective")) {
                tOptions.add("cp:objective");
            }
            if (v.getOptions().contains("cp:binary") || this.options.contains("cp:binary")) {
                tOptions.add("cp:binary");
            } else if (v.getOptions().contains("cp:btree") || this.options.contains("cp:btree")) {
                tOptions.add("cp:btree");
            } else if (v.getOptions().contains("cp:enum") || this.options.contains("cp:enum")) {
                tOptions.add("cp:enum");
            } else if (v.getOptions().contains("cp:blist") || this.options.contains("cp:blist")) {
                tOptions.add("cp:blist");
            } else if (v.getOptions().contains("cp:link") || this.options.contains("cp:link")) {
                tOptions.add("cp:link");
            } else if (v.getOptions().contains("cp:bound") || this.options.contains("cp:bound")) {
                tOptions.add("cp:bound");
            }
            this.options = tOptions;
            return true;
        }
    }
}

