/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.BoundAllDiff;
import choco.cp.solver.constraints.global.matching.AllDifferent;
import choco.cp.solver.constraints.global.scheduling.Cumulative;
import choco.cp.solver.constraints.integer.DistanceXYC;
import choco.cp.solver.constraints.integer.DistanceXYZ;
import choco.cp.solver.constraints.integer.IntLinComb;
import choco.cp.solver.constraints.integer.bool.BoolIntLinComb;
import choco.cp.solver.constraints.integer.channeling.ReifiedIntSConstraint;
import choco.cp.solver.search.integer.branching.AssignVar;
import choco.cp.solver.search.integer.branching.DomOverWDegBranching;
import choco.cp.solver.search.integer.branching.ImpactBasedBranching;
import choco.cp.solver.search.integer.valiterator.IncreasingDomain;
import choco.cp.solver.search.integer.varselector.DomOverDynDeg;
import choco.cp.solver.search.integer.varselector.MinDomain;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class PPSearch {
    protected CPModel mod;

    public void setModel(CPModel m) {
        this.mod = m;
    }

    public boolean isNaryExtensional() {
        return this.mod.getNbConstraintByType(ConstraintType.TABLE) > 0;
    }

    public boolean isSat() {
        return this.mod.getNbConstraintByType(ConstraintType.CLAUSES) > 0;
    }

    public boolean isScheduling() {
        return this.mod.getNbConstraintByType(ConstraintType.DISJUNCTIVE) != 0;
    }

    public boolean isReified() {
        return this.mod.getConstraintByType(ConstraintType.REIFIEDINTCONSTRAINT).hasNext();
    }

    public boolean isMixedScheduling() {
        return this.mod.getNbConstraintByType(ConstraintType.DISJUNCTIVE) + this.mod.getNbConstraintByType(ConstraintType.PRECEDING) + this.mod.getNbConstraintByType(ConstraintType.LEQ) + this.mod.getNbConstraintByType(ConstraintType.LT) + this.mod.getNbConstraintByType(ConstraintType.GT) + this.mod.getNbConstraintByType(ConstraintType.GEQ) != this.mod.getNbConstraints();
    }

    public boolean setVersatile(CPSolver s, int inittime) {
        int h = this.determineHeuristic(s);
        if (h == 2) {
            return this.setImpact(s, inittime);
        }
        return this.setDomOverWeg(s, inittime);
    }

    public boolean setDomOverDeg(CPSolver s) {
        s.setVarIntSelector(new DomOverDynDeg(s));
        s.setValIntIterator(new IncreasingDomain());
        return true;
    }

    public boolean setDomOverWeg(CPSolver s, int inittime) {
        if (this.isSat() && s.getNbIntConstraints() == 1) {
            return this.setImpact(s, inittime);
        }
        if (this.isScheduling()) {
            if (!this.isMixedScheduling()) {
                DomOverWDegBranching dwd = new DomOverWDegBranching((Solver)s, new IncreasingDomain());
                dwd.setBranchingVars(this.getBooleanVars(s));
                s.attachGoal(dwd);
                AssignVar dwd2 = new AssignVar((VarSelector)new MinDomain(s, this.getOtherVars(s)), new IncreasingDomain());
                s.addGoal(dwd2);
            } else {
                DomOverWDegBranching dwd = new DomOverWDegBranching((Solver)s, new IncreasingDomain());
                dwd.setBranchingVars(this.concat(this.getBooleanVars(s), this.getOtherVars(s)));
                s.attachGoal(dwd);
            }
        } else if (this.isReified()) {
            DomOverWDegBranching dwd = new DomOverWDegBranching((Solver)s, new IncreasingDomain());
            dwd.setBranchingVars(this.getBooleanVars(s));
            s.attachGoal(dwd);
            AssignVar dwd2 = new AssignVar((VarSelector)new MinDomain(s, this.getOtherVars(s)), new IncreasingDomain());
            s.addGoal(dwd2);
        } else {
            DomOverWDegBranching dwd = new DomOverWDegBranching((Solver)s, new IncreasingDomain());
            s.attachGoal(dwd);
        }
        return true;
    }

    public boolean setImpact(CPSolver s, int initialisationtime) {
        IntDomainVar[] bvs = this.getBooleanVars(s);
        IntDomainVar[] ovs = this.getOtherVars(s);
        if (this.isScheduling()) {
            if (!this.isMixedScheduling()) {
                ImpactBasedBranching ibb = new ImpactBasedBranching(s, bvs);
                if (!ibb.getImpactStrategy().initImpacts(initialisationtime)) {
                    return false;
                }
                s.attachGoal(ibb);
                AssignVar dwd2 = new AssignVar((VarSelector)new MinDomain(s, ovs), new IncreasingDomain());
                s.addGoal(dwd2);
            } else {
                ImpactBasedBranching ibb = new ImpactBasedBranching(s, this.concat(this.getBooleanVars(s), this.getOtherVars(s)));
                if (!ibb.getImpactStrategy().initImpacts(initialisationtime)) {
                    return false;
                }
                s.attachGoal(ibb);
            }
        } else if (this.isReified()) {
            ImpactBasedBranching ibb = new ImpactBasedBranching(s, bvs);
            if (!ibb.getImpactStrategy().initImpacts(initialisationtime)) {
                return false;
            }
            s.attachGoal(ibb);
            AssignVar dwd2 = new AssignVar((VarSelector)new MinDomain(s, ovs), new IncreasingDomain());
            s.addGoal(dwd2);
        } else {
            ImpactBasedBranching ibb = new ImpactBasedBranching(s);
            if (!ibb.getImpactStrategy().initImpacts(initialisationtime)) {
                return false;
            }
            s.attachGoal(ibb);
        }
        return true;
    }

    public IntDomainVar[] getBooleanVars(CPSolver s) {
        ArrayList<IntDomainVar> ldvs = new ArrayList<IntDomainVar>();
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntDomainVar v = (IntDomainVar)s.getIntVar(i);
            if (!v.hasBooleanDomain()) continue;
            ldvs.add(v);
        }
        IntDomainVar[] vs = new IntDomainVar[ldvs.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = (IntDomainVar)ldvs.get(i);
        }
        return vs;
    }

    public IntDomainVar[] getOtherVars(CPSolver s) {
        ArrayList<IntDomainVar> ldvs = new ArrayList<IntDomainVar>();
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntDomainVar v = (IntDomainVar)s.getIntVar(i);
            if (v.getDomainSize() <= 2) continue;
            ldvs.add(v);
        }
        IntDomainVar[] vs = new IntDomainVar[ldvs.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = (IntDomainVar)ldvs.get(i);
        }
        return vs;
    }

    public IntDomainVar[] concat(IntDomainVar[] t1, IntDomainVar[] t2) {
        IntDomainVar[] vs = new IntDomainVar[t1.length + t2.length];
        System.arraycopy(t1, 0, vs, 0, t1.length);
        System.arraycopy(t2, 0, vs, t1.length, t2.length);
        return vs;
    }

    public int determineHeuristic(CPSolver s) {
        Iterator<SConstraint> it = s.getIntConstraintIterator();
        int heuristic = 1;
        if (this.isSat()) {
            return 2;
        }
        if (this.isNaryExtensional()) {
            return 1;
        }
        while (it.hasNext()) {
            int arity;
            SConstraint constraint = it.next();
            if (constraint instanceof Cumulative) {
                return 2;
            }
            if (constraint instanceof AllDifferent) {
                return 2;
            }
            if (constraint instanceof BoundAllDiff && constraint.getNbVars() > 10) {
                heuristic = 2;
            }
            if (constraint instanceof ReifiedIntSConstraint) {
                return 2;
            }
            if ((constraint instanceof IntLinComb || constraint instanceof BoolIntLinComb) && (arity = constraint.getNbVars()) >= 6) {
                return 2;
            }
            if (constraint instanceof DistanceXYZ) {
                return 1;
            }
            if (!(constraint instanceof DistanceXYC)) continue;
            return 1;
        }
        if (this.getSumOfDomains(s) > 500000) {
            return 1;
        }
        return heuristic;
    }

    public int getSumOfDomains(CPSolver s) {
        int sum = 0;
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            sum += ((IntDomainVar)s.getIntVar(i)).getDomainSize();
        }
        return sum;
    }

    public static class BoolSchedComparator
    implements Comparator {
        public int compare(Object o, Object o1) {
            int sd2;
            int sd1 = (Integer)((AbstractVar)o).getExtension(2);
            if (sd1 > (sd2 = ((Integer)((AbstractVar)o1).getExtension(2)).intValue())) {
                return -1;
            }
            if (sd1 == sd2) {
                return 0;
            }
            return 1;
        }
    }
}

