/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.goals;

import choco.cp.solver.goals.choice.Generate;
import choco.cp.solver.search.SearchLoop;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.goals.solver.ChoicePoint;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GoalSearchSolver
extends AbstractGlobalSearchStrategy {
    protected final Goal mainGoal;
    protected List<GoalTrace> goalTraceStack;
    protected List<Goal> currentGoalStack;
    protected ChoicePoint currentChoice;
    protected int currentChoiceIndex;
    protected boolean globalContradiction = false;
    int lastRealMove = 4;

    public GoalSearchSolver(Solver s, Goal mainGoal) {
        super(s);
        this.setSearchLoop(new SearchLoop(this));
        this.mainGoal = mainGoal;
    }

    public void setGlobalContradiction() {
        this.globalContradiction = true;
    }

    public void pushGoalTrace() {
        GoalTrace trace = new GoalTrace(this.currentChoice, this.currentGoalStack, this.currentChoiceIndex);
        this.goalTraceStack.add(trace);
        ArrayList<Goal> l2 = new ArrayList<Goal>();
        l2.addAll(this.currentGoalStack);
        this.currentChoice = null;
        this.currentChoiceIndex = -1;
        this.currentGoalStack = l2;
    }

    public void popGoalTrace() {
        int l = this.goalTraceStack.size();
        if (l == 0) {
            this.currentGoalStack = null;
            this.currentChoice = null;
            this.currentChoiceIndex = -1;
        } else {
            GoalTrace trace = this.goalTraceStack.get(l - 1);
            this.goalTraceStack.remove(l - 1);
            this.currentGoalStack = trace.goalStack;
            this.currentChoice = trace.choicePoint;
            this.currentChoiceIndex = trace.choiceIndex;
        }
    }

    public ChoicePoint lastChoicePoint() {
        int l = this.goalTraceStack.size();
        if (l == 0) {
            return null;
        }
        GoalTrace trace = this.goalTraceStack.get(l - 1);
        return trace.choicePoint;
    }

    public Goal popGoal() {
        int l = this.currentGoalStack.size();
        if (l == 0) {
            return null;
        }
        Goal g = this.currentGoalStack.get(l - 1);
        this.currentGoalStack.remove(l - 1);
        return g;
    }

    public void pushGoal(Goal g) {
        this.currentGoalStack.add(g);
    }

    @Override
    public Boolean nextSolution() {
        int previousNbSolutions = this.nbSolutions;
        this.encounteredLimit = null;
        boolean stop = false;
        if (this.nextMove == 0) {
            this.nextMove = 1;
            this.currentGoalStack = new ArrayList<Goal>();
            this.currentGoalStack.add(this.mainGoal);
            this.goalTraceStack = new ArrayList<GoalTrace>();
        }
        block9: while (!stop) {
            switch (this.nextMove) {
                case 1: {
                    Goal g;
                    try {
                        while (this.currentChoice == null && !stop) {
                            g = this.popGoal();
                            if (g == null) {
                                this.recordSolution();
                                this.nextMove = 2;
                                stop = true;
                                continue;
                            }
                            if (g instanceof ChoicePoint) {
                                this.currentChoice = (ChoicePoint)g;
                                this.currentChoiceIndex = 0;
                                this.nextMove = 4;
                                continue;
                            }
                            if (g instanceof Generate) {
                                Logger.getLogger("i_want_to_use_this_old_version_of_choco.search.branching").log(Level.FINE, "generate " + g, new Object[]{0, null, " pop ", 0});
                                this.newTreeNode();
                            }
                            Goal newG = g.execute(this.getSolver());
                            this.getSolver().propagate();
                            if (newG == null) continue;
                            this.pushGoal(newG);
                        }
                        continue block9;
                    }
                    catch (ContradictionException e) {
                        Logger.getLogger("i_want_to_use_this_old_version_of_choco.search.branching").log(Level.FINE, "contradiction", new Object[]{0, null, " pop ", 0});
                        this.nextMove = 2;
                        break;
                    }
                }
                case 2: {
                    this.popGoalTrace();
                    if (this.currentChoice == null) {
                        stop = true;
                        break;
                    }
                    if (this.globalContradiction) {
                        this.nextMove = 2;
                    }
                    try {
                        this.getSolver().worldPop();
                        this.endTreeNode();
                        this.postDynamicCut();
                        ++this.currentChoiceIndex;
                        if (this.currentChoiceIndex < this.currentChoice.getNbChoices()) {
                            this.nextMove = 4;
                            break;
                        }
                        this.nextMove = 2;
                    }
                    catch (ContradictionException e) {
                        this.nextMove = 2;
                    }
                    break;
                }
                case 4: {
                    this.getSolver().worldPush();
                    Goal g = this.currentChoice.getChoice(this.currentChoiceIndex);
                    this.pushGoalTrace();
                    this.pushGoal(g);
                    this.nextMove = 1;
                    break;
                }
            }
        }
        for (int i = 0; i < this.limits.size(); ++i) {
            AbstractGlobalSearchLimit lim = (AbstractGlobalSearchLimit)this.limits.get(i);
            lim.reset(false);
        }
        if (this.nbSolutions > previousNbSolutions) {
            return Boolean.TRUE;
        }
        if (this.isEncounteredLimit()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private static class GoalTrace {
        final ChoicePoint choicePoint;
        int choiceIndex;
        final List<Goal> goalStack;

        GoalTrace(ChoicePoint choicePoint, List<Goal> goalStack, int choiceIndex) {
            this.goalStack = goalStack;
            this.choicePoint = choicePoint;
            this.choiceIndex = choiceIndex;
        }
    }
}

