/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractTernSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class SetUnion
extends AbstractTernSetSConstraint {
    public SetUnion(SetVar sv1, SetVar sv2, SetVar sv3) {
        super(sv1, sv2, sv3);
        this.v0 = sv1;
        this.v1 = sv2;
        this.v2 = sv3;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        switch (varIdx) {
            case 0: {
                this.v2.addToKernel(x, this.cIdx2);
                break;
            }
            case 1: {
                this.v2.addToKernel(x, this.cIdx2);
                break;
            }
            case 2: {
                if (!this.v0.isInDomainEnveloppe(x)) {
                    this.v1.addToKernel(x, this.cIdx1);
                }
                if (this.v1.isInDomainEnveloppe(x)) break;
                this.v0.addToKernel(x, this.cIdx0);
                break;
            }
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        switch (varIdx) {
            case 0: {
                if (this.v1.isInDomainEnveloppe(x)) break;
                this.v2.remFromEnveloppe(x, this.cIdx2);
                break;
            }
            case 1: {
                if (this.v0.isInDomainEnveloppe(x)) break;
                this.v2.remFromEnveloppe(x, this.cIdx2);
                break;
            }
            case 2: {
                this.v0.remFromEnveloppe(x, this.cIdx0);
                this.v1.remFromEnveloppe(x, this.cIdx1);
                break;
            }
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        switch (varIdx) {
            case 0: {
                IntIterator it1 = this.v0.getDomain().getKernelIterator();
                while (it1.hasNext()) {
                    int val = it1.next();
                    this.v2.addToKernel(val, this.cIdx2);
                }
                IntIterator it4 = this.v2.getDomain().getEnveloppeIterator();
                while (it4.hasNext()) {
                    int val = it4.next();
                    if (this.v0.isInDomainEnveloppe(val) || this.v1.isInDomainEnveloppe(val)) continue;
                    this.v2.remFromEnveloppe(val, this.cIdx2);
                }
                break;
            }
            case 1: {
                IntIterator it2 = this.v1.getDomain().getKernelIterator();
                while (it2.hasNext()) {
                    int val = it2.next();
                    this.v2.addToKernel(val, this.cIdx2);
                }
                IntIterator it5 = this.v2.getDomain().getEnveloppeIterator();
                while (it5.hasNext()) {
                    int val = it5.next();
                    if (this.v0.isInDomainEnveloppe(val) || this.v1.isInDomainEnveloppe(val)) continue;
                    this.v2.remFromEnveloppe(val, this.cIdx2);
                }
                break;
            }
            case 2: {
                IntIterator it3 = this.v2.getDomain().getKernelIterator();
                while (it3.hasNext()) {
                    int val = it3.next();
                    if (!this.v0.isInDomainEnveloppe(val)) {
                        this.v1.addToKernel(val, this.cIdx1);
                    }
                    if (this.v1.isInDomainEnveloppe(val)) continue;
                    this.v0.addToKernel(val, this.cIdx0);
                }
                break;
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        IntIterator it1 = this.v0.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            int val = it1.next();
            this.v2.addToKernel(val, this.cIdx2);
        }
        IntIterator it2 = this.v1.getDomain().getKernelIterator();
        while (it2.hasNext()) {
            int val = it2.next();
            this.v2.addToKernel(val, this.cIdx2);
        }
        IntIterator it3 = this.v2.getDomain().getKernelIterator();
        while (it3.hasNext()) {
            int val = it3.next();
            if (!this.v0.isInDomainEnveloppe(val)) {
                this.v1.addToKernel(val, this.cIdx1);
            }
            if (this.v1.isInDomainEnveloppe(val)) continue;
            this.v0.addToKernel(val, this.cIdx0);
        }
        IntIterator it4 = this.v2.getDomain().getEnveloppeIterator();
        while (it4.hasNext()) {
            int val = it4.next();
            if (this.v0.isInDomainEnveloppe(val) || this.v1.isInDomainEnveloppe(val)) continue;
            this.v2.remFromEnveloppe(val, this.cIdx2);
        }
    }

    public String toString() {
        return this.v0 + " UNION " + this.v1 + " = " + this.v2;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " UNION " + this.v1.pretty() + " = " + this.v2.pretty();
    }

    @Override
    public boolean isSatisfied() {
        boolean allin = true;
        IntIterator it1 = this.v2.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            int val = it1.next();
            if (this.v0.isInDomainKernel(val) || this.v1.isInDomainKernel(val)) continue;
            allin = false;
        }
        if (!allin) {
            return false;
        }
        IntIterator it2 = this.v1.getDomain().getKernelIterator();
        while (it2.hasNext()) {
            int val = it2.next();
            if (this.v2.isInDomainKernel(val)) continue;
            allin = false;
        }
        if (!allin) {
            return false;
        }
        IntIterator it3 = this.v0.getDomain().getKernelIterator();
        while (it3.hasNext()) {
            int val = it3.next();
            if (this.v2.isInDomainKernel(val)) continue;
            allin = false;
        }
        return allin;
    }

    @Override
    public boolean isConsistent() {
        return false;
    }
}

