/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractBinSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class SetNotEq
extends AbstractBinSetSConstraint {
    public SetNotEq(SetVar sv1, SetVar sv2) {
        super(sv1, sv2);
        this.v0 = sv1;
        this.v1 = sv2;
    }

    public boolean checkAreEqual() throws ContradictionException {
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v0.getKernelDomainSize() == this.v1.getKernelDomainSize()) {
            IntIterator it1 = this.v0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (this.v1.isInDomainKernel(it1.next())) continue;
                return false;
            }
            this.fail();
        }
        return false;
    }

    public boolean checkAreNotEqual(SetVar instVar, SetVar otherVar) {
        IntIterator it1 = instVar.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            if (otherVar.isInDomainEnveloppe(it1.next())) continue;
            return true;
        }
        it1 = otherVar.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            if (instVar.isInDomainEnveloppe(it1.next())) continue;
            return true;
        }
        return false;
    }

    public void filterForInst(SetVar instvar, SetVar otherVar, int idx) throws ContradictionException {
        block5: {
            int deltaSize;
            block4: {
                deltaSize = otherVar.getEnveloppeDomainSize() - otherVar.getKernelDomainSize();
                if (deltaSize != 0) break block4;
                this.checkAreEqual();
                break block5;
            }
            if (deltaSize != 1 || this.checkAreNotEqual(instvar, otherVar)) break block5;
            if (otherVar.getEnveloppeDomainSize() > instvar.getKernelDomainSize()) {
                IntIterator it1 = otherVar.getDomain().getEnveloppeIterator();
                while (it1.hasNext()) {
                    int val = it1.next();
                    if (otherVar.isInDomainKernel(val)) continue;
                    otherVar.addToKernel(val, idx);
                }
            } else {
                IntIterator it1 = otherVar.getDomain().getEnveloppeIterator();
                while (it1.hasNext()) {
                    int val = it1.next();
                    if (otherVar.isInDomainKernel(val)) continue;
                    otherVar.remFromEnveloppe(val, idx);
                }
            }
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            if (!this.v1.isInDomainEnveloppe(x)) {
                this.setPassive();
            } else if (this.v1.isInstantiated()) {
                this.filterForInst(this.v1, this.v0, 0);
            }
        } else if (!this.v0.isInDomainEnveloppe(x)) {
            this.setPassive();
        } else if (this.v0.isInstantiated()) {
            this.filterForInst(this.v0, this.v1, 1);
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            if (this.v1.isInDomainKernel(x)) {
                this.setPassive();
            } else if (this.v1.isInstantiated()) {
                this.filterForInst(this.v1, this.v0, 0);
            }
        } else if (this.v0.isInDomainKernel(x)) {
            this.setPassive();
        } else if (this.v0.isInstantiated()) {
            this.filterForInst(this.v0, this.v1, 1);
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (varIdx == 0) {
            this.filterForInst(this.v0, this.v1, 1);
        } else {
            this.filterForInst(this.v1, this.v0, 0);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.filterForInst(this.v0, this.v1, 1);
        }
        if (this.v1.isInstantiated()) {
            this.filterForInst(this.v1, this.v0, 0);
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v0.getKernelDomainSize() == this.v1.getKernelDomainSize()) {
            IntIterator it1 = this.v0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (this.v1.isInDomainKernel(it1.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    public String toString() {
        return this.v0 + " neq " + this.v1;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " neq " + this.v1.pretty();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not done on setvars");
    }
}

