/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractTernSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class SetIntersection
extends AbstractTernSetSConstraint {
    public SetIntersection(SetVar sv1, SetVar sv2, SetVar sv3) {
        super(sv1, sv2, sv3);
        this.v0 = sv1;
        this.v1 = sv2;
        this.v2 = sv3;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            if (this.v1.isInDomainKernel(x)) {
                this.v2.addToKernel(x, this.cIdx2);
            }
            if (!this.v2.isInDomainEnveloppe(x)) {
                this.v1.remFromEnveloppe(x, this.cIdx1);
            }
        } else if (varIdx == 1) {
            if (this.v0.isInDomainKernel(x)) {
                this.v2.addToKernel(x, this.cIdx2);
            }
            if (!this.v2.isInDomainEnveloppe(x)) {
                this.v0.remFromEnveloppe(x, this.cIdx0);
            }
        } else {
            if (!this.v0.isInDomainKernel(x)) {
                this.v0.addToKernel(x, this.cIdx0);
            }
            if (!this.v1.isInDomainKernel(x)) {
                this.v1.addToKernel(x, this.cIdx1);
            }
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            this.v2.remFromEnveloppe(x, this.cIdx2);
        } else if (varIdx == 1) {
            this.v2.remFromEnveloppe(x, this.cIdx2);
        } else {
            if (this.v0.isInDomainKernel(x)) {
                this.v1.remFromEnveloppe(x, this.cIdx1);
            }
            if (this.v1.isInDomainKernel(x)) {
                this.v0.remFromEnveloppe(x, this.cIdx0);
            }
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (varIdx == 0) {
            int x;
            IntIterator it1 = this.v0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                x = it1.next();
                if (this.v1.isInDomainKernel(x)) {
                    this.v2.addToKernel(x, this.cIdx2);
                }
                if (this.v2.isInDomainEnveloppe(x)) continue;
                this.v1.remFromEnveloppe(x, this.cIdx1);
            }
            IntIterator it2 = this.v2.getDomain().getEnveloppeIterator();
            while (it2.hasNext()) {
                x = it2.next();
                if (this.v0.isInDomainKernel(x)) continue;
                this.v2.remFromEnveloppe(x, this.cIdx2);
            }
        } else if (varIdx == 1) {
            int x;
            IntIterator it1 = this.v1.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                x = it1.next();
                if (this.v0.isInDomainKernel(x)) {
                    this.v2.addToKernel(x, this.cIdx2);
                }
                if (this.v2.isInDomainEnveloppe(x)) continue;
                this.v0.remFromEnveloppe(x, this.cIdx0);
            }
            IntIterator it2 = this.v2.getDomain().getEnveloppeIterator();
            while (it2.hasNext()) {
                x = it2.next();
                if (this.v1.isInDomainKernel(x)) continue;
                this.v2.remFromEnveloppe(x, this.cIdx2);
            }
        } else {
            IntIterator it1 = this.v2.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                int x = it1.next();
                if (!this.v0.isInDomainKernel(x)) {
                    this.v0.addToKernel(x, this.cIdx0);
                }
                if (this.v1.isInDomainKernel(x)) continue;
                this.v1.addToKernel(x, this.cIdx1);
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        IntIterator it1 = this.v0.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            int val = it1.next();
            if (this.v1.isInDomainKernel(val)) {
                this.v2.addToKernel(val, this.cIdx2);
            }
            if (this.v2.isInDomainEnveloppe(val)) continue;
            this.v1.remFromEnveloppe(val, this.cIdx1);
        }
        IntIterator it2 = this.v1.getDomain().getKernelIterator();
        while (it2.hasNext()) {
            int val = it2.next();
            if (this.v0.isInDomainKernel(val)) {
                this.v2.addToKernel(val, this.cIdx2);
            }
            if (this.v2.isInDomainEnveloppe(val)) continue;
            this.v0.remFromEnveloppe(val, this.cIdx0);
        }
        IntIterator it3 = this.v2.getDomain().getKernelIterator();
        while (it3.hasNext()) {
            int val = it3.next();
            if (!this.v0.isInDomainKernel(val)) {
                this.v0.addToKernel(val, this.cIdx0);
            }
            if (this.v1.isInDomainKernel(val)) continue;
            this.v1.addToKernel(val, this.cIdx1);
        }
        IntIterator it4 = this.v2.getDomain().getEnveloppeIterator();
        while (it4.hasNext()) {
            int val = it4.next();
            if (this.v0.isInDomainEnveloppe(val) && this.v1.isInDomainEnveloppe(val)) continue;
            this.v2.remFromEnveloppe(val, this.cIdx2);
        }
    }

    public String toString() {
        return this.v0 + " intersect " + this.v1 + " = " + this.v2;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " intersect " + this.v1.pretty() + " = " + this.v2.pretty();
    }

    @Override
    public boolean isSatisfied() {
        boolean nonout = true;
        boolean allIn = true;
        IntIterator it3 = this.v2.getDomain().getKernelIterator();
        while (it3.hasNext()) {
            int val = it3.next();
            if (this.v0.isInDomainKernel(val) && this.v1.isInDomainKernel(val)) continue;
            allIn = false;
            break;
        }
        if (!allIn) {
            return false;
        }
        IntIterator it2 = this.v1.getDomain().getKernelIterator();
        while (it2.hasNext()) {
            int val = it2.next();
            if (this.v2.isInDomainKernel(val) || !this.v0.isInDomainKernel(val)) continue;
            nonout = false;
            break;
        }
        return nonout;
    }

    @Override
    public boolean isConsistent() {
        return false;
    }
}

