/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractBinSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class SetEq
extends AbstractBinSetSConstraint {
    public SetEq(SetVar sv1, SetVar sv2) {
        super(sv1, sv2);
        this.v0 = sv1;
        this.v1 = sv2;
    }

    public void filterEq() throws ContradictionException {
        int val;
        IntIterator it0 = this.v0.getDomain().getKernelIterator();
        while (it0.hasNext()) {
            this.v1.addToKernel(it0.next(), this.cIdx1);
        }
        IntIterator it1 = this.v1.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            this.v0.addToKernel(it1.next(), this.cIdx0);
        }
        it0 = this.v0.getDomain().getEnveloppeIterator();
        while (it0.hasNext()) {
            val = it0.next();
            if (this.v1.isInDomainEnveloppe(val)) continue;
            this.v0.remFromEnveloppe(val, this.cIdx0);
        }
        it1 = this.v1.getDomain().getEnveloppeIterator();
        while (it1.hasNext()) {
            val = it1.next();
            if (this.v0.isInDomainEnveloppe(val)) continue;
            this.v1.remFromEnveloppe(val, this.cIdx1);
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            this.v1.addToKernel(x, this.cIdx1);
        } else {
            this.v0.addToKernel(x, this.cIdx0);
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            this.v1.remFromEnveloppe(x, this.cIdx1);
        } else {
            this.v0.remFromEnveloppe(x, this.cIdx1);
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.filterEq();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filterEq();
    }

    @Override
    public boolean isSatisfied() {
        if (this.v0.getKernelDomainSize() == this.v1.getKernelDomainSize()) {
            IntIterator it1 = this.v0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (this.v1.isInDomainKernel(it1.next())) continue;
                return false;
            }
            it1 = this.v1.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (this.v0.isInDomainKernel(it1.next())) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    public String toString() {
        return this.v0 + " = " + this.v1;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " = " + this.v1.pretty();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not done on setvars");
    }
}

