/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractBinSetIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;

public class SetCard
extends AbstractBinSetIntSConstraint {
    protected boolean inf = false;
    protected boolean sup = false;

    public SetCard(SetVar sv, IntDomainVar iv, boolean inf, boolean sup) {
        super(iv, sv);
        this.inf = inf;
        this.sup = sup;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void reactOnInfAndEnvEvents(int envSize) throws ContradictionException {
        if (this.v0.getInf() > envSize) {
            this.fail();
        } else if (this.v0.getInf() == envSize) {
            IntIterator it = this.v1.getDomain().getOpenDomainIterator();
            while (it.hasNext()) {
                this.v1.addToKernel(it.next(), this.cIdx1);
            }
        }
    }

    public void reactOnSupAndKerEvents(int kerSize) throws ContradictionException {
        if (this.v0.getSup() < kerSize) {
            this.fail();
        } else if (this.v0.getSup() == kerSize) {
            IntIterator it = this.v1.getDomain().getOpenDomainIterator();
            while (it.hasNext()) {
                this.v1.remFromEnveloppe(it.next(), this.cIdx1);
            }
        }
    }

    public void filter() throws ContradictionException {
        block9: {
            int kerSize;
            int envSize;
            block11: {
                block12: {
                    block7: {
                        block10: {
                            block8: {
                                envSize = this.v1.getEnveloppeDomainSize();
                                kerSize = this.v1.getKernelDomainSize();
                                if (!this.inf || !this.sup) break block7;
                                if (this.v0.getSup() >= kerSize && this.v0.getInf() <= envSize) break block8;
                                this.fail();
                                break block9;
                            }
                            if (kerSize >= envSize) break block9;
                            if (this.v0.getInf() != envSize) break block10;
                            IntIterator it = this.v1.getDomain().getOpenDomainIterator();
                            while (it.hasNext()) {
                                this.v1.addToKernel(it.next(), this.cIdx1);
                            }
                            break block9;
                        }
                        if (this.v0.getSup() != kerSize) break block9;
                        IntIterator it = this.v1.getDomain().getOpenDomainIterator();
                        while (it.hasNext()) {
                            this.v1.remFromEnveloppe(it.next(), this.cIdx1);
                        }
                        break block9;
                    }
                    if (!this.inf) break block11;
                    if (this.v0.getSup() >= kerSize) break block12;
                    this.fail();
                    break block9;
                }
                if (kerSize >= envSize || this.v0.getSup() != kerSize) break block9;
                IntIterator it = this.v1.getDomain().getOpenDomainIterator();
                while (it.hasNext()) {
                    this.v1.remFromEnveloppe(it.next(), this.cIdx1);
                }
                break block9;
            }
            if (this.v0.getInf() > envSize) {
                this.fail();
            } else if (kerSize < envSize && this.v0.getInf() == envSize) {
                IntIterator it = this.v1.getDomain().getOpenDomainIterator();
                while (it.hasNext()) {
                    this.v1.addToKernel(it.next(), this.cIdx1);
                }
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.inf) {
            this.reactOnInfAndEnvEvents(this.v1.getEnveloppeDomainSize());
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.sup) {
            this.reactOnSupAndKerEvents(this.v1.getKernelDomainSize());
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnkerAdditions(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (this.inf) {
            int kerSize = this.v1.getKernelDomainSize();
            this.v0.updateInf(kerSize, this.cIdx0);
            this.reactOnSupAndKerEvents(kerSize);
        }
    }

    @Override
    public void awakeOnEnvRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (this.sup) {
            int envSize = this.v1.getEnveloppeDomainSize();
            this.v0.updateSup(envSize, this.cIdx0);
            this.reactOnInfAndEnvEvents(envSize);
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (varIdx == 1) {
            int kerSize = this.v1.getKernelDomainSize();
            if (this.inf && this.sup) {
                this.v0.instantiate(kerSize, this.cIdx0);
            } else if (this.inf) {
                this.v0.updateInf(kerSize, this.cIdx0);
            } else {
                this.v0.updateSup(kerSize, this.cIdx0);
            }
        } else {
            this.filter();
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.inf && this.sup) {
            return this.v1.getKernelDomainSize() == this.v0.getVal();
        }
        if (this.inf) {
            return this.v1.getKernelDomainSize() <= this.v0.getVal();
        }
        return this.v1.getKernelDomainSize() >= this.v0.getVal();
    }

    public String toString() {
        if (this.inf && !this.sup) {
            return " |" + this.v1 + "| <= " + this.v0;
        }
        if (!this.inf && this.sup) {
            return " |" + this.v1 + "| >= " + this.v0;
        }
        return " |" + this.v1 + "| = " + this.v0;
    }

    @Override
    public String pretty() {
        if (this.inf && !this.sup) {
            return " |" + this.v1.pretty() + "| <= " + this.v0.pretty();
        }
        if (!this.inf && this.sup) {
            return " |" + this.v1.pretty() + "| >= " + this.v0.pretty();
        }
        return " |" + this.v1.pretty() + "| = " + this.v0.pretty();
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.inf && this.sup) {
            this.v0.updateInf(this.v1.getKernelDomainSize(), this.cIdx0);
            this.v0.updateSup(this.v1.getEnveloppeDomainSize(), this.cIdx0);
        } else if (this.inf) {
            this.v0.updateInf(this.v1.getKernelDomainSize(), this.cIdx0);
        } else {
            this.v0.updateSup(this.v1.getEnveloppeDomainSize(), this.cIdx0);
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public boolean isConsistent() {
        return this.v1.isInstantiated() && this.v0.isInstantiated() && this.isSatisfied();
    }

    @Override
    public Boolean isEntailed() {
        if (this.inf & this.sup) {
            if (this.v0.getInf() > this.v1.getEnveloppeDomainSize()) {
                return Boolean.FALSE;
            }
            if (this.v0.getSup() < this.v1.getKernelDomainSize()) {
                return Boolean.FALSE;
            }
            if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.inf) {
            if (this.v0.getSup() < this.v1.getKernelDomainSize()) {
                return Boolean.FALSE;
            }
            if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.v0.getInf() > this.v1.getEnveloppeDomainSize()) {
            return Boolean.FALSE;
        }
        if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
            return Boolean.TRUE;
        }
        return null;
    }
}

