/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractBinSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class IsNotIncluded
extends AbstractBinSetSConstraint {
    public boolean prune;

    public IsNotIncluded(SetVar sv1, SetVar sv2) {
        super(sv1, sv2);
        this.v0 = sv1;
        this.v1 = sv2;
    }

    public boolean isKer1IncludedInKer2(SetVar x0, SetVar x1) {
        if (x0.getKernelDomainSize() <= x1.getKernelDomainSize()) {
            IntIterator it1 = x0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (x1.isInDomainKernel(it1.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isKer1IncludedInEnv2(SetVar x0, SetVar x1) {
        if (x0.getKernelDomainSize() <= x1.getEnveloppeDomainSize()) {
            IntIterator it1 = x0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (x1.isInDomainEnveloppe(it1.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int findUniqueOutsider() throws ContradictionException {
        this.prune = false;
        IntIterator it1 = this.v0.getDomain().getEnveloppeIterator();
        int uniqueOutsider = Integer.MAX_VALUE;
        while (it1.hasNext()) {
            int val = it1.next();
            if (this.v1.isInDomainKernel(val)) continue;
            if (!this.prune) {
                uniqueOutsider = val;
                this.prune = true;
                continue;
            }
            this.prune = false;
            return Integer.MAX_VALUE;
        }
        if (!this.prune) {
            this.fail();
        }
        return uniqueOutsider;
    }

    public void filter() throws ContradictionException {
        int uniqueOutsider = this.findUniqueOutsider();
        if (this.prune) {
            if (this.v0.isInDomainKernel(uniqueOutsider)) {
                this.v1.remFromEnveloppe(uniqueOutsider, -1);
            }
            if (!this.v1.isInDomainEnveloppe(uniqueOutsider)) {
                this.v0.addToKernel(uniqueOutsider, -1);
            }
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        if (varIdx == 1 && this.v0.isInDomainKernel(x)) {
            this.setPassive();
        }
        this.filter();
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0 && !this.v1.isInDomainEnveloppe(x)) {
            this.setPassive();
        }
        this.filter();
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public boolean isSatisfied() {
        IntIterator it2 = this.v0.getDomain().getKernelIterator();
        while (it2.hasNext()) {
            if (this.v1.isInDomainKernel(it2.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    public String toString() {
        return this.v0 + " is Not Included in " + this.v1;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " is Not Included in " + this.v1.pretty();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not done on setvars");
    }
}

