/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractBinSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class Disjoint
extends AbstractBinSetSConstraint {
    public Disjoint(SetVar sv1, SetVar sv2) {
        super(sv1, sv2);
        this.v0 = sv1;
        this.v1 = sv2;
    }

    public void filter(int idx) throws ContradictionException {
        block3: {
            block2: {
                if (idx != 0) break block2;
                IntIterator it1 = this.v0.getDomain().getKernelIterator();
                while (it1.hasNext()) {
                    this.v1.remFromEnveloppe(it1.next(), this.cIdx1);
                }
                break block3;
            }
            if (idx != 1) break block3;
            IntIterator it2 = this.v1.getDomain().getKernelIterator();
            while (it2.hasNext()) {
                this.v0.remFromEnveloppe(it2.next(), this.cIdx0);
            }
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            this.v1.remFromEnveloppe(x, this.cIdx1);
        } else {
            this.v0.remFromEnveloppe(x, this.cIdx0);
        }
    }

    @Override
    public void awakeOnEnvRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.filter(varIdx);
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter(0);
        this.filter(1);
    }

    @Override
    public boolean isSatisfied() {
        IntIterator it2 = this.v1.getDomain().getKernelIterator();
        while (it2.hasNext()) {
            if (!this.v0.isInDomainKernel(it2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    public String toString() {
        return this.v0 + " disjoint " + this.v1;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " disjoint " + this.v1.pretty();
    }

    @Override
    public Boolean isEntailed() {
        boolean someSureIn = false;
        boolean somePossibleIn = false;
        IntIterator it1 = this.v0.getDomain().getEnveloppeIterator();
        while (it1.hasNext()) {
            int val = it1.next();
            if (!this.v1.isInDomainEnveloppe(val)) continue;
            if (this.v0.isInDomainKernel(val) && this.v1.isInDomainKernel(val)) {
                someSureIn = true;
                break;
            }
            somePossibleIn = true;
        }
        if (someSureIn) {
            return Boolean.FALSE;
        }
        if (!somePossibleIn) {
            return Boolean.TRUE;
        }
        return null;
    }
}

