/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.IPretty;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractLargeSetIntSConstraint;
import choco.kernel.solver.variables.integer.IntVar;
import choco.kernel.solver.variables.set.SetDomain;
import choco.kernel.solver.variables.set.SetVar;

abstract class AbstractBoundOfASet
extends AbstractLargeSetIntSConstraint {
    public static final int SET_INDEX = 0;
    public static final int BOUND_INDEX = 0;
    public static final int VARS_OFFSET = 1;

    public AbstractBoundOfASet(IntVar[] intvars, SetVar setvar) {
        super(intvars, new SetVar[]{setvar});
        if (setvar.getEnveloppeInf() < 0 || setvar.getEnveloppeSup() > intvars.length - 2) {
            throw new SolverException("The enveloppe of the set variable " + setvar.pretty() + " is larger than the array");
        }
    }

    protected final int getConstraintIntIdx(int idx) {
        return this.getConstraintIdx(2);
    }

    protected final boolean isInKernel(int idx) {
        return this.svars[0].isInDomainKernel(idx);
    }

    protected final boolean isInEnveloppe(int idx) {
        return this.svars[0].isInDomainEnveloppe(idx);
    }

    protected final SetDomain getSetDomain() {
        return this.svars[0].getDomain();
    }

    protected final boolean isNotEmptySet() {
        return this.svars[0].getCard().getInf() > 0;
    }

    protected final boolean isSetInstantiated() {
        return this.svars[0].isInstantiated();
    }

    protected final boolean updateBoundInf(int val) throws ContradictionException {
        return this.ivars[0].updateInf(val, this.getConstraintIntIdx(0));
    }

    protected final boolean updateBoundSup(int val) throws ContradictionException {
        return this.ivars[0].updateSup(val, this.getConstraintIntIdx(0));
    }

    protected final boolean removeFromEnv(int idx) throws ContradictionException {
        return this.removeFromEnv(idx, this.ivars[0].getInf(), this.ivars[0].getSup());
    }

    protected final boolean removeFromEnv(int idx, int minValue, int maxValue) throws ContradictionException {
        if (this.ivars[1 + idx].getSup() < minValue || this.ivars[1 + idx].getInf() > maxValue) {
            return this.svars[0].remFromEnveloppe(idx, this.getConstraintIdx(0));
        }
        return false;
    }

    protected final boolean updateEnveloppe() throws ContradictionException {
        int minValue = this.ivars[0].getInf();
        int maxValue = this.ivars[0].getSup();
        IntIterator iter = this.getSetDomain().getOpenDomainIterator();
        boolean update = false;
        while (iter.hasNext()) {
            this.removeFromEnv(iter.next(), minValue, maxValue);
        }
        return update;
    }

    @Override
    public void awakeOnEnvRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (idx == 0 && deltaDomain.hasNext()) {
            this.awakeOnEnv(idx, deltaDomain.next());
        }
    }

    @Override
    public void awakeOnkerAdditions(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (idx == 0 && deltaDomain.hasNext()) {
            this.awakeOnKer(idx, deltaDomain.next());
        }
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on MaxOfAList");
    }

    @Override
    public boolean isConsistent() {
        return false;
    }

    @Override
    public boolean isSatisfied() {
        return false;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.svars[0].pretty());
        sb.append(ChocoUtil.pretty((IPretty[])this.ivars));
        return new String(sb);
    }
}

