/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.integer.bool.BinOr;
import choco.cp.solver.constraints.integer.bool.LargeOr;
import choco.cp.solver.constraints.integer.channeling.ReifiedLargeOr;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class OrNode
extends AbstractBoolNode
implements BoolNode {
    public OrNode(INode ... subt) {
        super(subt, NodeType.OR);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (!((BoolNode)((Object)this.subtrees[i])).checkTuple(tuple)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        if (vs.length > 1) {
            IntDomainVar v = s.createBooleanVar("reifiedOr");
            s.post(new ReifiedLargeOr(v, vs));
            return v;
        }
        return vs[0];
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        if (this.subtrees.length == 2) {
            return new BinOr(vs[0], vs[1]);
        }
        return new LargeOr(vs);
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuffer st = new StringBuffer("(");
        for (i = 0; i < this.subtrees.length - 1; ++i) {
            st.append(this.subtrees[i].pretty()).append(" or ");
        }
        st.append(this.subtrees[i].pretty()).append(")");
        return st.toString();
    }
}

