/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.global.Occurrence;
import choco.cp.solver.constraints.integer.channeling.ReifiedIntSConstraint;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class AndNode
extends AbstractBoolNode {
    public AndNode(INode ... subt) {
        super(subt, NodeType.AND);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (((BoolNode)((Object)this.subtrees[i])).checkTuple(tuple)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntExp[] vs = new IntDomainVar[this.subtrees.length];
        IntDomainVar sand = s.createBoundIntVar("reifiedAnd", 0, this.subtrees.length);
        IntDomainVar v = s.createBooleanVar("reifiedAnd");
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        s.post(s.eq(s.sum(vs), (IntExp)sand));
        s.post(new ReifiedIntSConstraint(v, (AbstractIntSConstraint)s.eq((IntExp)sand, this.subtrees.length)));
        return v;
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length + 1];
        for (int i = 0; i < vs.length - 1; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        vs[vs.length - 1] = new IntDomainVarImpl(s, "and_occurence", 1, this.subtrees.length, this.subtrees.length);
        return new Occurrence(vs, 1, true, true);
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuffer st = new StringBuffer("(");
        for (i = 0; i < this.subtrees.length - 1; ++i) {
            st.append(this.subtrees[i].pretty()).append(" and ");
        }
        st.append(this.subtrees[i].pretty()).append(")");
        return st.toString();
    }
}

