/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class PlusNode
extends INode
implements ArithmNode {
    public PlusNode(INode[] subt) {
        super(subt, NodeType.PLUS);
    }

    @Override
    public int eval(int[] tuple) {
        return ((ArithmNode)((Object)this.subtrees[0])).eval(tuple) + ((ArithmNode)((Object)this.subtrees[1])).eval(tuple);
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar v1 = this.subtrees[0].extractResult(s);
        IntDomainVar v2 = this.subtrees[1].extractResult(s);
        IntDomainVar v3 = null;
        int a = v1.getInf() + v2.getInf();
        int b = v1.getInf() + v2.getSup();
        int c = v1.getSup() + v2.getInf();
        int d = v1.getSup() + v2.getSup();
        int lb = Math.min(Math.min(Math.min(a, b), c), d);
        int ub = Math.max(Math.max(Math.max(a, b), c), d);
        v3 = lb == 0 && ub == 1 ? s.createBooleanVar("intermin") : (v1.hasEnumeratedDomain() && v2.hasEnumeratedDomain() ? s.createEnumIntVar("intermin", lb, ub) : s.createBoundIntVar("intermin", lb, ub));
        s.post(s.eq((IntExp)v3, s.plus((IntExp)v1, (IntExp)v2)));
        return v3;
    }

    @Override
    public String pretty() {
        return "(" + this.subtrees[0].pretty() + " + " + this.subtrees[1].pretty() + ")";
    }

    @Override
    public boolean isALinearTerm() {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isALinearTerm()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] computeLinearExpr(int scope) {
        int[] coeffs = this.subtrees[0].computeLinearExpr(scope);
        int[] coeffToAdd = this.subtrees[1].computeLinearExpr(scope);
        for (int i = 0; i < coeffToAdd.length; ++i) {
            int n = i;
            coeffs[n] = coeffs[n] + coeffToAdd[i];
        }
        return coeffs;
    }
}

