/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class NegNode
extends INode
implements ArithmNode {
    public NegNode(INode[] subt) {
        super(subt, NodeType.NEG);
    }

    @Override
    public int eval(int[] tuple) {
        return -((ArithmNode)((Object)this.subtrees[0])).eval(tuple);
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar v1 = this.subtrees[0].extractResult(s);
        IntDomainVar v2 = null;
        int lb = Math.min(Math.min(Math.min(v1.getInf(), -v1.getInf()), v1.getSup()), -v1.getSup());
        int ub = Math.max(Math.max(Math.max(v1.getInf(), -v1.getInf()), v1.getSup()), -v1.getSup());
        v2 = lb == 0 && ub == 1 ? s.createBooleanVar("iNeg") : (v1.hasEnumeratedDomain() ? s.createEnumIntVar("iNeg", lb, ub) : s.createBoundIntVar("iNeg", lb, ub));
        s.post(s.eq(s.plus((IntExp)v1, (IntExp)v2), 0));
        return v2;
    }

    @Override
    public String pretty() {
        return "-(" + this.subtrees[0].pretty() + ")";
    }

    @Override
    public boolean isALinearTerm() {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isALinearTerm()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] computeLinearExpr(int scope) {
        int[] coeffs = this.subtrees[0].computeLinearExpr(scope);
        for (int i = 0; i < coeffs.length; ++i) {
            coeffs[i] = -coeffs[i];
        }
        return coeffs;
    }
}

