/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.cp.solver.constraints.integer.MinOfAList;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class MinNode
extends INode
implements ArithmNode {
    public MinNode(INode[] subt) {
        super(subt, NodeType.MIN);
    }

    @Override
    public int eval(int[] tuple) {
        int mineval = Integer.MAX_VALUE;
        for (int i = 0; i < this.subtrees.length; ++i) {
            mineval = Math.min(((ArithmNode)((Object)this.subtrees[i])).eval(tuple), mineval);
        }
        return mineval;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        int i;
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        IntDomainVar vmin = null;
        boolean allenum = true;
        for (i = 0; i < this.subtrees.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
            allenum |= vs[i].hasEnumeratedDomain();
        }
        if (vs.length == 1) {
            return vs[0];
        }
        int lb = vs[0].getInf();
        int ub = vs[0].getSup();
        for (i = 1; i < vs.length; ++i) {
            lb = Math.min(lb, vs[i].getInf());
            ub = Math.max(ub, vs[i].getSup());
        }
        vmin = lb == 0 && ub == 1 ? s.createBooleanVar("intermin") : (allenum ? s.createEnumIntVar("iMin", lb, ub) : s.createBoundIntVar("iMin", lb, ub));
        IntDomainVar[] tmpVars = new IntDomainVar[vs.length + 1];
        tmpVars[0] = vmin;
        System.arraycopy(vs, 0, tmpVars, 1, vs.length);
        s.post(new MinOfAList(tmpVars));
        return vmin;
    }

    @Override
    public String pretty() {
        String s = "min(";
        for (int i = 0; i < this.subtrees.length - 1; ++i) {
            s = s + this.subtrees[i].pretty() + ",";
        }
        return s + this.subtrees[this.subtrees.length - 1].pretty() + ")";
    }
}

