/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.cp.solver.constraints.integer.EuclideanDivisionXYZ;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class DivNode
extends INode
implements ArithmNode {
    public DivNode(INode[] subt) {
        super(subt, NodeType.DIV);
    }

    @Override
    public int eval(int[] tuple) {
        int r1 = ((ArithmNode)((Object)this.subtrees[1])).eval(tuple);
        if (r1 == 0) {
            return Integer.MAX_VALUE;
        }
        return ((ArithmNode)((Object)this.subtrees[0])).eval(tuple) / r1;
    }

    @Override
    public boolean isDecompositionPossible() {
        return false;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar v1 = this.subtrees[0].extractResult(s);
        IntDomainVar v2 = this.subtrees[1].extractResult(s);
        IntDomainVar v3 = null;
        int lb = Math.min(v1.getInf(), v2.getInf());
        int ub = Math.max(v1.getSup(), v2.getSup());
        if (lb == 0 && ub == 1) {
            v3 = s.createBooleanVar("interdiv");
        }
        v3 = v1.hasEnumeratedDomain() && v2.hasEnumeratedDomain() ? s.createEnumIntVar("interdiv", lb, ub) : s.createBoundIntVar("interdiv", lb, ub);
        s.post(new EuclideanDivisionXYZ(v1, v2, v3));
        return v3;
    }

    @Override
    public String pretty() {
        return "(" + this.subtrees[0].pretty() + " / " + this.subtrees[1].pretty() + ")";
    }
}

