/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.cp.solver.constraints.integer.Absolute;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class AbsNode
extends INode
implements ArithmNode {
    public AbsNode(INode[] subt) {
        super(subt, NodeType.ABS);
    }

    @Override
    public int eval(int[] tuple) {
        return Math.abs(((ArithmNode)((Object)this.subtrees[0])).eval(tuple));
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar v1 = this.subtrees[0].extractResult(s);
        IntDomainVar v2 = null;
        int lb = Math.max(v1.getInf(), 0);
        int ub = Math.max(Math.abs(v1.getInf()), Math.abs(v1.getSup()));
        v2 = lb == 0 && ub == 1 ? s.createBooleanVar("iAbs") : (v1.hasEnumeratedDomain() ? s.createEnumIntVar("iAbs", lb, ub) : s.createBoundIntVar("iAbs", lb, ub));
        s.post(new Absolute(v2, v1));
        return v2;
    }

    @Override
    public String pretty() {
        return "(|" + this.subtrees[0].pretty() + "|)";
    }
}

