/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.real.exp;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.constraints.real.exp.AbstractRealBinTerm;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealMath;

public class RealMult
extends AbstractRealBinTerm {
    public RealMult(Solver solver, RealExp exp1, RealExp exp2) {
        super(solver, exp1, exp2);
    }

    @Override
    public String pretty() {
        return this.exp1.pretty() + " * " + this.exp2.pretty();
    }

    @Override
    public void tighten() {
        RealInterval res = RealMath.mul(this.exp1, this.exp2);
        this.inf.set(res.getInf());
        this.sup.set(res.getSup());
    }

    @Override
    public void project() throws ContradictionException {
        RealInterval res = RealMath.odiv_wrt(this, this.exp2, this.exp1);
        if (res.getInf() > res.getSup()) {
            this.solver.getPropagationEngine().raiseContradiction(this, 3);
        }
        this.exp1.intersect(res);
        res = RealMath.odiv_wrt(this, this.exp1, this.exp2);
        if (res.getInf() > res.getSup()) {
            this.solver.getPropagationEngine().raiseContradiction(this, 3);
        }
        this.exp2.intersect(res);
    }
}

