/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.real.exp;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.real.RealInterval;

public class RealIntervalImpl
implements RealInterval {
    protected double inf;
    protected double sup;
    Solver solver;

    public RealIntervalImpl(double inf, double sup) {
        this.inf = inf;
        this.sup = sup;
    }

    public RealIntervalImpl() {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public RealIntervalImpl(RealInterval i) {
        this(i.getInf(), i.getSup());
    }

    public String toString() {
        return "[" + this.inf + "," + this.sup + "]";
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public double getInf() {
        return this.inf;
    }

    @Override
    public double getSup() {
        return this.sup;
    }

    @Override
    public void intersect(RealInterval interval) throws ContradictionException {
        this.intersect(interval, -1);
    }

    @Override
    public void intersect(RealInterval interval, int index) throws ContradictionException {
        if (interval.getInf() > this.inf) {
            this.inf = interval.getInf();
        }
        if (interval.getSup() < this.sup) {
            this.sup = interval.getSup();
        }
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }
}

