/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.real.exp;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.constraints.real.exp.AbstractRealUnTerm;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealMath;

public class RealIntegerPower
extends AbstractRealUnTerm {
    protected int power;

    public RealIntegerPower(Solver solver, RealExp exp1, int power) {
        super(solver, exp1);
        this.power = power;
    }

    @Override
    public String pretty() {
        return this.exp1.pretty() + "^" + this.power;
    }

    @Override
    public void tighten() {
        RealInterval res = RealMath.iPower(this.exp1, this.power);
        this.inf.set(res.getInf());
        this.sup.set(res.getSup());
    }

    @Override
    public void project() throws ContradictionException {
        RealInterval res = RealMath.iRoot(this, this.power, this.exp1);
        if (res.getInf() > res.getSup()) {
            this.solver.getPropagationEngine().raiseContradiction(this, 3);
        }
        this.exp1.intersect(res);
    }
}

