/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;

public class GAC3rmLargeConstraint
extends CspLargeSConstraint {
    protected int[] supports;
    protected int[] blocks;
    protected int size;
    protected int[] offsets;
    protected DisposableIntIterator[] seekIter;

    public GAC3rmLargeConstraint(IntDomainVar[] vs, LargeRelation relation) {
        super(vs, relation);
        int i;
        this.size = vs.length;
        this.blocks = new int[this.size];
        this.offsets = new int[this.size];
        int nbElt = 0;
        for (i = 0; i < this.size; ++i) {
            this.offsets[i] = vs[i].getInf();
            this.blocks[i] = nbElt;
            if (!this.vars[i].hasEnumeratedDomain()) {
                nbElt += 2;
                continue;
            }
            nbElt += this.vars[i].getSup() - this.vars[i].getInf() + 1;
        }
        this.supports = new int[nbElt * this.size];
        this.seekIter = new DisposableIntIterator[this.size];
        for (i = 0; i < this.size; ++i) {
            this.seekIter[i] = this.vars[i].getDomain().getIterator();
        }
        Arrays.fill(this.supports, Integer.MIN_VALUE);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public void initializeSupports(int indexVar) throws ContradictionException {
        IntDomain dom = this.vars[indexVar].getDomain();
        if (this.vars[indexVar].hasEnumeratedDomain()) {
            DisposableIntIterator it = dom.getIterator();
            while (it.hasNext()) {
                int val = it.next();
                if (this.lastSupport(indexVar, val)[0] != Integer.MIN_VALUE) continue;
                int[] currentSupport = this.seekNextSupport(indexVar, val);
                if (currentSupport != null) {
                    this.setSupport(currentSupport);
                    continue;
                }
                this.vars[indexVar].removeVal(val, this.cIndices[indexVar]);
            }
            it.dispose();
        } else {
            int[] currentSupport;
            int val;
            for (val = this.vars[indexVar].getInf(); val <= this.vars[indexVar].getSup(); ++val) {
                currentSupport = this.seekNextSupport(indexVar, val);
                if (currentSupport == null) continue;
                this.setBoundSupport(indexVar, 0, currentSupport);
                break;
            }
            this.vars[indexVar].updateInf(val, this.cIndices[indexVar]);
            for (val = this.vars[indexVar].getSup(); val >= this.vars[indexVar].getInf(); --val) {
                currentSupport = this.seekNextSupport(indexVar, val);
                if (currentSupport == null) continue;
                this.setBoundSupport(indexVar, 1, currentSupport);
                break;
            }
            this.vars[indexVar].updateSup(val, this.cIndices[indexVar]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseVar(int indexVar) throws ContradictionException {
        IntDomain dom = this.vars[indexVar].getDomain();
        if (this.vars[indexVar].hasEnumeratedDomain()) {
            DisposableIntIterator it = dom.getIterator();
            try {
                while (it.hasNext()) {
                    int val = it.next();
                    if (this.isValid(this.lastSupport(indexVar, val))) continue;
                    int[] currentSupport = this.seekNextSupport(indexVar, val);
                    if (currentSupport != null) {
                        this.setSupport(currentSupport);
                        continue;
                    }
                    this.vars[indexVar].removeVal(val, this.cIndices[indexVar]);
                }
            }
            finally {
                it.dispose();
            }
        } else {
            int[] currentSupport;
            int val;
            int[] inf_supports = this.lastBoundSupport(indexVar, 0);
            if (this.vars[indexVar].getInf() != inf_supports[indexVar] || !this.isValid(inf_supports)) {
                for (val = this.vars[indexVar].getInf(); val <= this.vars[indexVar].getSup(); ++val) {
                    currentSupport = this.seekNextSupport(indexVar, val);
                    if (currentSupport == null) continue;
                    this.setBoundSupport(indexVar, 0, currentSupport);
                    break;
                }
                this.vars[indexVar].updateInf(val, this.cIndices[indexVar]);
            }
            int[] sup_supports = this.lastBoundSupport(indexVar, 1);
            if (this.vars[indexVar].getSup() != sup_supports[indexVar] || !this.isValid(sup_supports)) {
                for (val = this.vars[indexVar].getSup(); val >= this.vars[indexVar].getInf(); --val) {
                    currentSupport = this.seekNextSupport(indexVar, val);
                    if (currentSupport == null) continue;
                    this.setBoundSupport(indexVar, 1, currentSupport);
                    break;
                }
                this.vars[indexVar].updateSup(val, this.cIndices[indexVar]);
            }
        }
    }

    public void setSupport(int[] support) {
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].hasEnumeratedDomain()) continue;
            this.setOneSupport(i, support[i], support);
        }
    }

    public void setOneSupport(int indexVar, int value, int[] support) {
        for (int i = 0; i < this.vars.length; ++i) {
            this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i] = support[i];
        }
    }

    public void setBoundSupport(int indexVar, int idxBound, int[] support) {
        for (int i = 0; i < this.vars.length; ++i) {
            this.supports[(this.blocks[indexVar] + idxBound) * this.size + i] = support[i];
        }
    }

    public int[] getSupport(int indexVar, int value) {
        int[] resultat = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            resultat[i] = this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i];
        }
        return resultat;
    }

    public int[] getBoundSupport(int indexVar, int idxBound) {
        int[] resultat = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            resultat[i] = this.supports[(this.blocks[indexVar] + idxBound) * this.size + i];
        }
        return resultat;
    }

    public int[] lastSupport(int indexVar, int value) {
        return this.getSupport(indexVar, value);
    }

    public int[] lastBoundSupport(int indexVar, int idxBound) {
        return this.getBoundSupport(indexVar, idxBound);
    }

    public boolean isValid(int[] tuple) {
        for (int i = 0; i < this.size; ++i) {
            if (this.vars[i].canBeInstantiatedTo(tuple[i])) continue;
            return false;
        }
        return true;
    }

    public int[] seekNextSupport(int indexVar, int val) {
        int[] currentSupport = new int[this.size];
        int k = 0;
        for (int i = 0; i < this.size; ++i) {
            this.seekIter[i].dispose();
            this.seekIter[i] = this.vars[i].getDomain().getIterator();
            currentSupport[i] = i != indexVar ? this.seekIter[i].next() : val;
        }
        if (this.relation.isConsistent(currentSupport)) {
            return currentSupport;
        }
        while (k < this.vars.length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= this.vars.length) continue;
            if (!this.seekIter[k].hasNext()) {
                this.seekIter[k].dispose();
                this.seekIter[k] = this.vars[k].getDomain().getIterator();
                currentSupport[k] = this.seekIter[k].next();
                ++k;
                continue;
            }
            currentSupport[k] = this.seekIter[k].next();
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
            k = 0;
        }
        return null;
    }

    @Override
    public void awake() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            this.initializeSupports(i);
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            this.reviseVar(i);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            if (idx == i) continue;
            this.reviseVar(i);
        }
        if (!this.vars[idx].hasEnumeratedDomain()) {
            this.reviseVar(idx);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            if (idx == i) continue;
            this.reviseVar(i);
        }
        if (!this.vars[idx].hasEnumeratedDomain()) {
            this.reviseVar(idx);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            if (idx == i) continue;
            this.reviseVar(i);
        }
        if (!this.vars[idx].hasEnumeratedDomain()) {
            this.reviseVar(idx);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            if (idx == i) continue;
            this.reviseVar(i);
        }
        if (!this.vars[idx].hasEnumeratedDomain()) {
            this.reviseVar(idx);
        }
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            if (varIndex == i) continue;
            this.reviseVar(i);
        }
        if (!this.vars[varIndex].hasEnumeratedDomain()) {
            this.reviseVar(varIndex);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            if (idx == i) continue;
            this.reviseVar(i);
        }
        if (!this.vars[idx].hasEnumeratedDomain()) {
            this.reviseVar(idx);
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("GAC3rmValidLarge({");
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("}) relation: ");
        return sb.toString();
    }
}

