/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.cp.solver.constraints.integer.extension.FastBooleanValidityChecker;
import choco.cp.solver.constraints.integer.extension.FastValidityChecker;
import choco.cp.solver.constraints.integer.extension.ValidityChecker;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.extension.IterTuplesTable;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class GAC2001PositiveLargeConstraint
extends CspLargeSConstraint {
    protected IStateInt[][] supports;
    protected int[] blocks;
    protected int arity;
    protected int[] offsets;
    protected static final int NO_SUPPORT = -2;
    protected IterTuplesTable relation;
    protected int[][][] tab;
    protected ValidityChecker valcheck;

    public GAC2001PositiveLargeConstraint(IntDomainVar[] vs, IterTuplesTable relation) {
        super(vs, null);
        this.relation = relation;
        this.solver = vs[0].getSolver();
        this.arity = vs.length;
        this.blocks = new int[this.arity];
        this.offsets = new int[this.arity];
        this.tab = relation.getTableLists();
        this.supports = new IStateInt[this.arity][];
        for (int i = 0; i < this.arity; ++i) {
            this.offsets[i] = vs[i].getInf();
            this.supports[i] = new IStateInt[vs[i].getSup() - vs[i].getInf() + 1];
            for (int j = 0; j < this.supports[i].length; ++j) {
                this.supports[i][j] = this.solver.getEnvironment().makeInt(0);
            }
        }
        int[][] tt = relation.getTupleTable();
        boolean fastValidCheckAllowed = true;
        boolean fastBooleanValidCheckAllowed = true;
        for (int i = 0; i < tt.length; ++i) {
            for (int j = 0; j < tt[i].length; ++j) {
                int lb = vs[j].getInf();
                int ub = vs[j].getSup();
                if (lb > tt[i][j] || ub < tt[i][j]) {
                    fastValidCheckAllowed = false;
                }
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
            }
            if (!fastBooleanValidCheckAllowed && !fastValidCheckAllowed) break;
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, this.vars) : (fastValidCheckAllowed ? new FastValidityChecker(this.arity, this.vars) : new ValidityChecker(this.arity, this.vars));
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public int[] getFavoriteDomains() {
        return new int[]{0, 2, 3, 1};
    }

    public void reviseVar(int indexVar) throws ContradictionException {
        DisposableIntIterator itv = this.vars[indexVar].getDomain().getIterator();
        while (itv.hasNext()) {
            int val = itv.next();
            int nva = val - this.relation.getRelationOffset(indexVar);
            int currentIdxSupport = this.getSupport(indexVar, val);
            if ((currentIdxSupport = this.seekNextSupport(indexVar, nva, currentIdxSupport)) == -2) {
                this.vars[indexVar].removeVal(val, this.cIndices[indexVar]);
                continue;
            }
            this.setSupport(indexVar, val, currentIdxSupport);
        }
    }

    public int seekNextSupport(int indexVar, int nva, int start) {
        int[] currentSupport = null;
        for (int i = start; i < this.tab[indexVar][nva].length; ++i) {
            int currentIdxSupport = this.tab[indexVar][nva][i];
            currentSupport = this.relation.getTuple(currentIdxSupport);
            if (!this.valcheck.isValid(currentSupport)) continue;
            return i;
        }
        return -2;
    }

    public void setSupport(int indexVar, int value, int idxSupport) {
        this.supports[indexVar][value - this.offsets[indexVar]].set(idxSupport);
    }

    public int getSupport(int indexVar, int value) {
        return this.supports[indexVar][value - this.offsets[indexVar]].get();
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int indexVar = 0; indexVar < this.arity; ++indexVar) {
            this.reviseVar(indexVar);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter(varIndex);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    public void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        for (int i = 0; i < this.arity; ++i) {
            if (idx == this.valcheck.position[i]) continue;
            this.reviseVar(this.valcheck.position[i]);
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("GAC2001AllowedLarge({");
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int minListIdx = -1;
        int minSize = Integer.MAX_VALUE;
        for (int i = 0; i < tuple.length; ++i) {
            if (this.tab[i][tuple[i] - this.offsets[i]].length >= minSize) continue;
            minSize = this.tab[i][tuple[i] - this.offsets[i]].length;
            minListIdx = i;
        }
        int nva = tuple[minListIdx] - this.relation.getRelationOffset(minListIdx);
        for (int i = 0; i < this.tab[minListIdx][nva].length; ++i) {
            int currentIdxSupport = this.tab[minListIdx][nva][i];
            int[] currentSupport = this.relation.getTuple(currentIdxSupport);
            boolean isValid = true;
            for (int j = 0; isValid && j < tuple.length; ++j) {
                if (tuple[j] == currentSupport[j]) continue;
                isValid = false;
            }
            if (!isValid) continue;
            return true;
        }
        return false;
    }
}

