/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.cp.solver.constraints.integer.extension.FastBooleanValidityChecker;
import choco.cp.solver.constraints.integer.extension.FastValidityChecker;
import choco.cp.solver.constraints.integer.extension.ValidityChecker;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class GAC2001LargeSConstraint
extends CspLargeSConstraint {
    protected IStateInt[] supports;
    protected int[] blocks;
    protected int size;
    protected int[] offsets;
    protected ValidityChecker valcheck;

    public GAC2001LargeSConstraint(IntDomainVar[] vs, LargeRelation relation) {
        super(vs, relation);
        int i;
        this.solver = vs[0].getSolver();
        this.size = vs.length;
        this.blocks = new int[this.size];
        this.offsets = new int[this.size];
        int nbElt = 0;
        boolean allboolean = true;
        for (i = 0; i < this.size; ++i) {
            this.offsets[i] = vs[i].getInf();
            this.blocks[i] = nbElt;
            if (!this.vars[i].hasBooleanDomain()) {
                allboolean = false;
            }
            if (!this.vars[i].hasEnumeratedDomain()) {
                throw new SolverException("GAC2001 can not be used with bound variables");
            }
            nbElt += this.vars[i].getSup() - this.vars[i].getInf() + 1;
        }
        this.supports = new IStateInt[nbElt * this.size];
        for (i = 0; i < this.supports.length; ++i) {
            this.supports[i] = this.solver.getEnvironment().makeInt(Integer.MIN_VALUE);
        }
        this.valcheck = allboolean ? new FastBooleanValidityChecker(this.size, this.vars) : new FastValidityChecker(this.size, this.vars);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public int[] getFavoriteDomains() {
        return new int[]{0, 2, 3, 1};
    }

    public void initializeSupports(int indexVar) throws ContradictionException {
        IntDomain dom = this.vars[indexVar].getDomain();
        int val = this.vars[indexVar].getInf();
        while (val <= this.vars[indexVar].getSup()) {
            int[] currentSupport = this.seekNextSupport(indexVar, val, true);
            if (currentSupport != null) {
                this.setSupport(indexVar, val, currentSupport);
            } else {
                this.vars[indexVar].removeVal(val, this.cIndices[indexVar]);
            }
            val = dom.getNextValue(val);
        }
    }

    public void reviseVar(int indexVar) throws ContradictionException {
        IntDomain dom = this.vars[indexVar].getDomain();
        int val = this.vars[indexVar].getInf();
        while (val <= this.vars[indexVar].getSup()) {
            int[] currentSupport = this.seekNextSupport(indexVar, val, false);
            if (currentSupport != null) {
                this.setSupport(indexVar, val, currentSupport);
            } else {
                this.vars[indexVar].removeVal(val, this.cIndices[indexVar]);
            }
            val = dom.getNextValue(val);
        }
    }

    public void setSupport(int indexVar, int value, int[] support) {
        for (int i = 0; i < this.vars.length; ++i) {
            this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].set(support[i]);
        }
    }

    public int[] getSupport(int indexVar, int value) {
        int[] resultat = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            resultat[i] = this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].get();
        }
        return resultat;
    }

    public int[] lastSupport(int indexVar, int value) {
        return this.getSupport(indexVar, value);
    }

    public int[] seekNextSupport(int indexVar, int val, boolean fromscratch) {
        int[] currentSupport = new int[this.size];
        int k = 0;
        if (fromscratch) {
            for (int i = 0; i < this.size; ++i) {
                currentSupport[i] = i != indexVar ? this.vars[i].getInf() : val;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        } else {
            currentSupport = this.getSupport(indexVar, val);
            if (this.valcheck.isValid(currentSupport)) {
                return currentSupport;
            }
            if ((currentSupport = this.getFirstValidTupleFrom(currentSupport, indexVar)) == null) {
                return null;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        }
        while (k < this.vars.length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= this.vars.length) continue;
            if (!this.vars[k].getDomain().hasNextValue(currentSupport[k])) {
                currentSupport[k] = this.vars[k].getInf();
                ++k;
                continue;
            }
            currentSupport[k] = this.vars[k].getDomain().getNextValue(currentSupport[k]);
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
            k = 0;
        }
        return null;
    }

    public int[] getFirstValidTupleFrom(int[] t, int indexVar) {
        int k = 0;
        while (k < this.vars.length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= this.vars.length) continue;
            if (!this.vars[k].getDomain().hasNextValue(t[k])) {
                t[k] = this.vars[k].getInf();
                ++k;
                continue;
            }
            t[k] = this.vars[k].getDomain().getNextValue(t[k]);
            if (this.valcheck.isValid(t)) {
                return t;
            }
            k = 0;
        }
        return null;
    }

    @Override
    public void awake() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            this.initializeSupports(i);
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            this.reviseVar(i);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter(varIndex);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    public void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        if (this.vars[idx].hasEnumeratedDomain()) {
            for (int i = 0; i < this.size; ++i) {
                if (idx == this.valcheck.position[i]) continue;
                this.reviseVar(this.valcheck.position[i]);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.reviseVar(this.valcheck.position[i]);
            }
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("GAC2001ValidLarge({");
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

