/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CspBinSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class FCBinSConstraint
extends CspBinSConstraint {
    public FCBinSConstraint(IntDomainVar x0, IntDomainVar x1, BinRelation rela) {
        super(x0, x1, rela);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public Object clone() {
        return new FCBinSConstraint(this.v0, this.v1, this.relation);
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.awakeOnInst(0);
        }
        if (this.v1.isInstantiated()) {
            this.awakeOnInst(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int value = this.v0.getVal();
            DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
            try {
                while (itv1.hasNext()) {
                    int val = itv1.next();
                    if (this.relation.isConsistent(value, val)) continue;
                    this.v1.removeVal(val, this.cIdx1);
                }
            }
            finally {
                itv1.dispose();
            }
        }
        int value = this.v1.getVal();
        DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
        try {
            while (itv0.hasNext()) {
                int val = itv0.next();
                if (this.relation.isConsistent(val, value)) continue;
                this.v0.removeVal(val, this.cIdx0);
            }
        }
        finally {
            itv0.dispose();
        }
    }

    @Override
    public AbstractSConstraint opposite() {
        BinRelation rela2 = (BinRelation)((Object)((ConsistencyRelation)((Object)this.relation)).getOpposite());
        FCBinSConstraint ct = new FCBinSConstraint(this.v0, this.v1, rela2);
        return ct;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("FC(").append(this.v0.pretty()).append(", ").append(this.v1.pretty()).append(", ").append(this.relation.getClass().getSimpleName()).append(")");
        return sb.toString();
    }
}

