/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class CspLargeSConstraint
extends AbstractLargeIntSConstraint {
    protected LargeRelation relation;
    protected int[] currentTuple;

    public CspLargeSConstraint(IntDomainVar[] vs, LargeRelation relation) {
        super(vs);
        this.relation = relation;
        this.currentTuple = new int[vs.length];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CspLargeSConstraint newc = (CspLargeSConstraint)super.clone();
        newc.currentTuple = new int[this.currentTuple.length];
        System.arraycopy(this.currentTuple, 0, newc.currentTuple, 0, this.currentTuple.length);
        return newc;
    }

    public LargeRelation getRelation() {
        return this.relation;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    @Override
    public void propagate() throws ContradictionException {
        boolean stop = false;
        int nbUnassigned = 0;
        int index = -1;
        for (int i = 0; !stop && i < this.vars.length; ++i) {
            if (!this.vars[i].isInstantiated()) {
                ++nbUnassigned;
                index = i;
            } else {
                this.currentTuple[i] = this.vars[i].getVal();
            }
            if (nbUnassigned <= 1) continue;
            stop = true;
        }
        if (!stop) {
            if (nbUnassigned == 1) {
                DisposableIntIterator it = this.vars[index].getDomain().getIterator();
                while (it.hasNext()) {
                    this.currentTuple[index] = it.next();
                    if (this.relation.isConsistent(this.currentTuple)) continue;
                    this.vars[index].removeVal(this.currentTuple[index], this.cIndices[index]);
                }
            } else if (!this.relation.isConsistent(this.currentTuple)) {
                this.fail();
            }
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.relation.isConsistent(tuple);
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("CSPLarge({");
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = this.vars[i];
            sb.append(", ");
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public AbstractSConstraint opposite() {
        LargeRelation rela2 = (LargeRelation)((Object)((ConsistencyRelation)((Object)this.relation)).getOpposite());
        CspLargeSConstraint ct = new CspLargeSConstraint(this.vars, rela2);
        return ct;
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented in CspLargeConstraint");
    }
}

