/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.channeling;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class ReifiedLargeOr
extends AbstractLargeIntSConstraint {
    protected int lit1 = Integer.MAX_VALUE;
    protected int lit2 = Integer.MAX_VALUE;

    public static IntDomainVar[] makeTable(IntDomainVar b, IntDomainVar[] vars) {
        IntDomainVar[] vs = new IntDomainVar[vars.length + 1];
        vs[0] = b;
        System.arraycopy(vars, 0, vs, 1, vars.length);
        return vs;
    }

    public ReifiedLargeOr(IntDomainVar b, IntDomainVar[] vars) {
        super(ReifiedLargeOr.makeTable(b, vars));
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void awake() throws ContradictionException {
        this.lit1 = Integer.MAX_VALUE;
        this.lit2 = Integer.MAX_VALUE;
        this.propagate();
    }

    public void initFilterFrombOne() throws ContradictionException {
        boolean updateLit1 = true;
        boolean updateLit2 = true;
        if (this.lit1 != Integer.MAX_VALUE && this.vars[this.lit1].fastCanBeInstantiatedTo(1)) {
            updateLit1 = false;
        }
        if (this.lit2 != Integer.MAX_VALUE && this.vars[this.lit2].fastCanBeInstantiatedTo(1)) {
            updateLit2 = false;
        }
        if (updateLit1 || updateLit2) {
            for (int i = 1; i < this.vars.length; ++i) {
                if (this.vars[i].isInstantiatedTo(1)) {
                    this.vars[0].instantiate(1, this.cIndices[0]);
                    this.setEntailed();
                    continue;
                }
                if (this.vars[i].isInstantiated()) continue;
                if (updateLit1 && this.lit1 > i) {
                    this.lit1 = i;
                    continue;
                }
                if (!updateLit2 || this.lit2 <= i) continue;
                this.lit2 = i;
                break;
            }
            if (this.vars[0].isInstantiatedTo(1)) {
                if (this.lit1 == Integer.MAX_VALUE) {
                    this.fail();
                } else if (this.lit2 == Integer.MAX_VALUE) {
                    this.vars[this.lit1].instantiate(1, this.cIndices[this.lit1]);
                }
            } else if (this.lit1 == Integer.MAX_VALUE && this.lit2 == Integer.MAX_VALUE) {
                this.vars[0].instantiate(0, this.cIndices[0]);
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.vars[0].isInstantiatedTo(0)) {
            for (int i = 1; i < this.vars.length; ++i) {
                this.vars[i].instantiate(0, this.cIndices[i]);
            }
        } else {
            this.initFilterFrombOne();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = this.vars[idx].getVal();
        if (idx == 0) {
            if (val == 0) {
                for (int i = 1; i < this.vars.length; ++i) {
                    this.vars[i].instantiate(0, this.cIndices[i]);
                }
            } else {
                if (this.vars[this.lit1].isInstantiatedTo(0)) {
                    this.vars[this.lit2].instantiate(1, this.cIndices[this.lit2]);
                }
                if (this.vars[this.lit2].isInstantiatedTo(0)) {
                    this.vars[this.lit1].instantiate(1, this.cIndices[this.lit1]);
                }
            }
        } else if (val == 1) {
            this.vars[0].instantiate(1, this.cIndices[0]);
            this.setEntailed();
        } else if (idx == this.lit1) {
            for (int i = 1; i < this.vars.length; ++i) {
                if (i == this.lit2 || !this.vars[i].fastCanBeInstantiatedTo(1)) continue;
                this.lit1 = i;
                break;
            }
            if (this.lit1 == idx) {
                if (this.vars[0].isInstantiatedTo(1)) {
                    this.vars[this.lit2].instantiate(1, this.cIndices[this.lit2]);
                } else if (this.vars[this.lit2].isInstantiatedTo(0)) {
                    this.vars[0].instantiate(0, this.cIndices[0]);
                }
            }
        } else if (idx == this.lit2) {
            for (int i = 1; i < this.vars.length; ++i) {
                if (i == this.lit1 || !this.vars[i].fastCanBeInstantiatedTo(1)) continue;
                this.lit2 = i;
                break;
            }
            if (this.lit2 == idx) {
                if (this.vars[0].isInstantiatedTo(1)) {
                    this.vars[this.lit1].instantiate(1, this.cIndices[this.lit1]);
                } else if (this.vars[this.lit1].isInstantiatedTo(0)) {
                    this.vars[0].instantiate(0, this.cIndices[0]);
                }
            }
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        if (tuple[0] == 0) {
            for (int i = 1; i < tuple.length; ++i) {
                if (tuple[i] == 0) continue;
                return false;
            }
            return true;
        }
        for (int i = 1; i < tuple.length; ++i) {
            if (tuple[i] != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean isEntailed() {
        int i;
        for (i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].isInstantiatedTo(1)) continue;
            return Boolean.TRUE;
        }
        for (i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].fastCanBeInstantiatedTo(1)) continue;
            return null;
        }
        return Boolean.FALSE;
    }
}

