/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.channeling;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.HashSet;
import java.util.Iterator;

public class ReifiedIntSConstraint
extends AbstractLargeIntSConstraint {
    protected AbstractIntSConstraint cons;
    protected AbstractIntSConstraint oppositeCons;
    protected int[] scopeCons;
    protected int[] scopeOCons;
    private int[] tupleCons;
    private int[] tupleOCons;

    public static IntDomainVar[] makeTableVar(IntDomainVar bool, AbstractIntSConstraint cons, AbstractIntSConstraint oppcons) {
        int i;
        HashSet<IntDomainVar> consV = new HashSet<IntDomainVar>();
        for (i = 0; i < cons.getNbVars(); ++i) {
            consV.add(cons.getIntVar(i));
        }
        for (i = 0; i < oppcons.getNbVars(); ++i) {
            consV.add(oppcons.getIntVar(i));
        }
        consV.add(bool);
        IntDomainVar[] vars = new IntDomainVar[consV.size()];
        consV.remove(bool);
        vars[0] = bool;
        int i2 = 1;
        Iterator it = consV.iterator();
        while (it.hasNext()) {
            IntDomainVar intDomainVar;
            vars[i2] = intDomainVar = (IntDomainVar)it.next();
            ++i2;
        }
        return vars;
    }

    public ReifiedIntSConstraint(IntDomainVar bool, AbstractIntSConstraint cons) {
        super(ReifiedIntSConstraint.makeTableVar(bool, cons, (AbstractIntSConstraint)cons.opposite()));
        this.cons = cons;
        this.oppositeCons = (AbstractIntSConstraint)cons.opposite();
        this.init();
    }

    public ReifiedIntSConstraint(IntDomainVar bool, AbstractIntSConstraint cons, AbstractIntSConstraint oppositeCons) {
        super(ReifiedIntSConstraint.makeTableVar(bool, cons, oppositeCons));
        this.cons = cons;
        this.oppositeCons = oppositeCons;
        this.init();
    }

    public void init() {
        int j;
        IntDomainVar v;
        int i;
        this.tupleCons = new int[this.cons.getNbVars()];
        this.tupleOCons = new int[this.oppositeCons.getNbVars()];
        this.scopeCons = new int[this.cons.getNbVars()];
        this.scopeOCons = new int[this.oppositeCons.getNbVars()];
        block0: for (i = 0; i < this.cons.getNbVars(); ++i) {
            v = this.cons.getIntVar(i);
            for (j = 0; j < this.vars.length; ++j) {
                if (!v.equals(this.vars[j])) continue;
                this.scopeCons[i] = j;
                continue block0;
            }
        }
        block2: for (i = 0; i < this.oppositeCons.getNbVars(); ++i) {
            v = this.oppositeCons.getIntVar(i);
            for (j = 0; j < this.vars.length; ++j) {
                if (!v.equals(this.vars[j])) continue;
                this.scopeOCons[i] = j;
                continue block2;
            }
        }
    }

    public void filterReifiedConstraintFromBool() throws ContradictionException {
        if (this.vars[0].isInstantiatedTo(1)) {
            this.cons.propagate();
        } else {
            this.oppositeCons.propagate();
        }
    }

    public void filterReifiedConstraintFromCons() throws ContradictionException {
        Boolean isEntailed = this.cons.isEntailed();
        if (isEntailed != null) {
            if (isEntailed.booleanValue()) {
                this.vars[0].instantiate(1, this.cIndices[0]);
            } else {
                this.vars[0].instantiate(0, -1);
            }
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (this.vars[idx].hasEnumeratedDomain()) {
            return 4;
        }
        return 3;
    }

    public void filter() throws ContradictionException {
        if (this.vars[0].isInstantiated()) {
            this.filterReifiedConstraintFromBool();
        } else {
            this.filterReifiedConstraintFromCons();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public void awake() throws ContradictionException {
        this.filter();
    }

    public void addListener(AbstractIntSConstraint thecons) {
        if (thecons instanceof ReifiedIntSConstraint) {
            ReifiedIntSConstraint rcons = (ReifiedIntSConstraint)thecons;
            this.addListener(rcons.cons);
            this.addListener(rcons.oppositeCons);
        }
        int n = thecons.getNbVars();
        for (int i = 0; i < n; ++i) {
            thecons.setConstraintIndex(i, this.getIndex((AbstractVar)thecons.getVar(i)));
        }
        thecons.solver = this.solver;
    }

    public int getIndex(AbstractVar v) {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i] != v) continue;
            return this.cIndices[i];
        }
        return -1;
    }

    @Override
    public void addListener(boolean dynamicAddition) {
        super.addListener(dynamicAddition);
        this.addListener(this.cons);
        this.addListener(this.oppositeCons);
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer("");
        sb.append(" 1");
        sb.append("<=>").append(this.cons.pretty());
        if (this.oppositeCons != null) {
            sb.append(" -- 0");
            sb.append("<=>").append(this.oppositeCons.pretty());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int val = tuple[0];
        if (val == 1) {
            for (int i = 0; i < this.tupleCons.length; ++i) {
                this.tupleCons[i] = tuple[this.scopeCons[i]];
            }
            return this.cons.isSatisfied(this.tupleCons);
        }
        for (int i = 0; i < this.tupleOCons.length; ++i) {
            this.tupleOCons[i] = tuple[this.scopeOCons[i]];
        }
        return this.oppositeCons.isSatisfied(this.tupleOCons);
    }
}

