/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sat;

import choco.cp.solver.constraints.integer.bool.sat.ClauseStore;
import choco.cp.solver.constraints.integer.bool.sat.Lits;
import choco.kernel.solver.ContradictionException;

public class WLClause {
    protected final int[] lits;
    protected final Lits voc;
    protected boolean isreg = false;

    public WLClause(int[] ps, Lits voc) {
        this.lits = ps;
        this.voc = voc;
    }

    public int getLitZero() {
        return this.lits[0];
    }

    public void findLiteral(int start) {
        for (int i = start; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            int tlit = this.lits[start];
            this.lits[start] = this.lits[i];
            this.lits[i] = tlit;
            break;
        }
    }

    public void register(ClauseStore propagator) throws ContradictionException {
        assert (this.lits.length > 1);
        this.findLiteral(0);
        if (this.voc.isFalsified(this.lits[0])) {
            propagator.fail();
        }
        this.findLiteral(1);
        if (this.voc.isFalsified(this.lits[1])) {
            this.updateDomain();
        }
        this.isreg = true;
        this.voc.watch(this.lits[0], this);
        this.voc.watch(this.lits[1], this);
    }

    public boolean propagate(int p, int idxcl) throws ContradictionException {
        if (this.lits[0] == p) {
            this.lits[0] = this.lits[1];
            this.lits[1] = p;
        }
        if (this.voc.isSatisfied(this.lits[0])) {
            return false;
        }
        for (int i = 2; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.lits[1] = this.lits[i];
            this.lits[i] = p;
            this.voc.unwatch(p, idxcl);
            this.voc.watch(this.lits[1], this);
            return true;
        }
        this.updateDomain();
        return false;
    }

    public void updateDomain() throws ContradictionException {
        if (this.lits[0] > 0) {
            this.voc.boolvars[this.lits[0]].instantiate(1, -1);
        } else {
            this.voc.boolvars[-this.lits[0]].instantiate(0, -1);
        }
    }

    public boolean simplePropagation(ClauseStore propagator) throws ContradictionException {
        int ivalid = -1;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            if (ivalid != -1) {
                return false;
            }
            ivalid = i;
        }
        if (ivalid == -1) {
            propagator.fail();
        } else {
            int litzero = this.lits[0];
            this.lits[0] = this.lits[ivalid];
            this.lits[ivalid] = litzero;
            this.updateDomain();
        }
        return true;
    }

    public boolean update() throws ContradictionException {
        if (this.voc.isFalsified(this.lits[0]) && !this.voc.isSatisfied(this.lits[1])) {
            int temp = this.lits[0];
            this.lits[0] = this.lits[1];
            this.lits[1] = temp;
            this.updateDomain();
            return true;
        }
        if (this.voc.isFalsified(this.lits[1]) && !this.voc.isSatisfied(this.lits[0])) {
            this.updateDomain();
            return true;
        }
        return false;
    }

    public boolean learnt() {
        return false;
    }

    public int size() {
        return this.lits.length;
    }

    public Lits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[this.size()];
        System.arraycopy(this.lits, 0, tmp, 0, this.size());
        return tmp;
    }

    public boolean isSatisfied() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered() {
        return this.isreg;
    }

    public String toString() {
        String clname = "";
        for (int i = 0; i < this.lits.length; ++i) {
            String s = "";
            s = this.lits[i] > 0 ? s + this.voc.boolvars[this.lits[i]].toString() : s + "!" + this.voc.boolvars[-this.lits[i]].toString();
            if (i >= this.lits.length - 1) continue;
            clname = clname + " v ";
        }
        return clname;
    }
}

