/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sat;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class Vec<T> {
    private static final long serialVersionUID = 1L;
    private static final int RANDOM_SEED = 91648253;
    private int nbelem;
    private T[] myarray;
    private static Random rand = new Random(91648253L);

    public Vec() {
        this(5);
    }

    public Vec(T[] elts) {
        this.myarray = elts;
        this.nbelem = elts.length;
    }

    public Vec(int size) {
        this.myarray = new Object[size];
    }

    public Vec(int size, T pad) {
        this.myarray = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.myarray[i] = pad;
        }
        this.nbelem = size;
    }

    public int size() {
        return this.nbelem;
    }

    public void shrink(int nofelems) {
        assert (nofelems <= this.nbelem);
        while (nofelems-- > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    public void shrinkTo(int newsize) {
        assert (newsize <= this.size());
        for (int i = this.nbelem; i > newsize; --i) {
            this.myarray[i - 1] = null;
        }
        this.nbelem = newsize;
        assert (this.size() == newsize);
    }

    public void pop() {
        assert (this.size() > 0);
        this.myarray[--this.nbelem] = null;
    }

    public void growTo(int newsize, T pad) {
        assert (newsize >= this.size());
        this.ensure(newsize);
        for (int i = this.nbelem; i < newsize; ++i) {
            this.myarray[i] = pad;
        }
        this.nbelem = newsize;
    }

    public final void ensure(int nsize) {
        if (nsize >= this.myarray.length) {
            Object[] narray = new Object[Math.max(nsize, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, narray, 0, this.nbelem);
            this.myarray = narray;
        }
    }

    public Vec<T> push(T elem) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = elem;
        return this;
    }

    public void unsafePush(T elem) {
        this.myarray[this.nbelem++] = elem;
    }

    public void insertFirst(T elem) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = elem;
            return;
        }
        this.push(elem);
    }

    public void insertFirstWithShifting(T elem) {
        if (this.nbelem > 0) {
            this.ensure(this.nbelem + 1);
            for (int i = this.nbelem; i > 0; --i) {
                this.myarray[i] = this.myarray[i - 1];
            }
            this.myarray[0] = elem;
            ++this.nbelem;
            return;
        }
        this.push(elem);
    }

    public void clear() {
        while (this.nbelem > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    public T last() {
        assert (this.size() != 0);
        return this.myarray[this.nbelem - 1];
    }

    public T get(int i) {
        return this.myarray[i];
    }

    public void set(int i, T o) {
        this.myarray[i] = o;
    }

    public void remove(T elem) {
        assert (this.size() > 0);
        int j = 0;
        while (this.myarray[j] != elem) {
            assert (j < this.size());
            ++j;
        }
        while (j < this.size() - 1) {
            this.myarray[j] = this.myarray[j + 1];
            ++j;
        }
        this.pop();
    }

    public T delete(int i) {
        assert (i >= 0);
        assert (i < this.nbelem);
        T ith = this.myarray[i];
        this.myarray[i] = this.myarray[--this.nbelem];
        this.myarray[this.nbelem] = null;
        return ith;
    }

    public void copyTo(Vec<T> copy) {
        Vec<T> ncopy = copy;
        int nsize = this.nbelem + ncopy.nbelem;
        copy.ensure(nsize);
        for (int i = 0; i < this.nbelem; ++i) {
            ncopy.myarray[i + ncopy.nbelem] = this.myarray[i];
        }
        ncopy.nbelem = nsize;
    }

    public <E> void copyTo(E[] dest) {
        assert (dest.length >= this.nbelem);
        System.arraycopy(this.myarray, 0, dest, 0, this.nbelem);
    }

    public void moveTo(Vec<T> dest) {
        this.copyTo(dest);
        this.clear();
    }

    public void moveTo(int dest, int source) {
        this.myarray[dest] = this.myarray[source];
        this.myarray[source] = null;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < this.nbelem - 1; ++i) {
            stb.append(this.myarray[i]);
            stb.append(",");
        }
        if (this.nbelem > 0) {
            stb.append(this.myarray[this.nbelem - 1]);
        }
        return stb.toString();
    }

    void selectionSort(int from, int to, Comparator<T> cmp) {
        for (int i = from; i < to - 1; ++i) {
            int best_i = i;
            for (int j = i + 1; j < to; ++j) {
                if (cmp.compare(this.myarray[j], this.myarray[best_i]) >= 0) continue;
                best_i = j;
            }
            T tmp = this.myarray[i];
            this.myarray[i] = this.myarray[best_i];
            this.myarray[best_i] = tmp;
        }
    }

    void sort(int from, int to, Comparator<T> cmp) {
        int width = to - from;
        if (to - from <= 15) {
            this.selectionSort(from, to, cmp);
        } else {
            T pivot = this.myarray[rand.nextInt(width) + from];
            int i = from - 1;
            int j = to;
            while (true) {
                if (cmp.compare(this.myarray[++i], pivot) < 0) {
                    continue;
                }
                while (cmp.compare(pivot, this.myarray[--j]) < 0) {
                }
                if (i >= j) break;
                T tmp = this.myarray[i];
                this.myarray[i] = this.myarray[j];
                this.myarray[j] = tmp;
            }
            this.sort(from, i, cmp);
            this.sort(i, to, cmp);
        }
    }

    public void sort(Comparator<T> comparator) {
        this.sort(0, this.nbelem, comparator);
    }

    public void sortUnique(Comparator<T> cmp) {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem, cmp);
        int i = 1;
        T last = this.myarray[0];
        for (int j = 1; j < this.nbelem; ++j) {
            if (cmp.compare(last, this.myarray[j]) >= 0) continue;
            last = this.myarray[i] = this.myarray[j];
            ++i;
        }
        this.nbelem = i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec) {
            Vec v = (Vec)obj;
            if (v.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (v.get(i).equals(this.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int sum = 0;
        for (int i = 0; i < this.nbelem; ++i) {
            sum += this.myarray.hashCode() / this.nbelem;
        }
        return sum;
    }

    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Vec.this.nbelem;
            }

            @Override
            public T next() {
                if (this.i == Vec.this.nbelem) {
                    throw new NoSuchElementException();
                }
                return Vec.this.myarray[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

