/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sat;

import choco.cp.solver.constraints.integer.bool.sat.ClauseStore;
import choco.cp.solver.constraints.integer.bool.sat.Lits;
import choco.cp.solver.constraints.integer.bool.sat.WLClause;
import choco.cp.solver.variables.integer.BooleanDomain;
import choco.cp.solver.variables.integer.BooleanVarImpl;
import choco.kernel.solver.ContradictionException;

public class DynWLClause
extends WLClause {
    public DynWLClause(int[] ps, Lits voc) {
        super(ps, voc);
    }

    @Override
    public void findLiteral(int start) {
        int maxlevel = -1;
        int lit = -1;
        for (int i = start; i < this.lits.length; ++i) {
            int var = this.lits[i] < 0 ? -this.lits[i] : this.lits[i];
            BooleanVarImpl v = this.voc.boolvars[var];
            if (!v.isInstantiated()) {
                int tlit = this.lits[start];
                this.lits[start] = this.lits[i];
                this.lits[i] = tlit;
                return;
            }
            int levdec = this.getLevelDec(v);
            if (maxlevel > levdec) continue;
            maxlevel = levdec;
            lit = i;
        }
        int tlit = this.lits[start];
        this.lits[start] = this.lits[lit];
        this.lits[lit] = tlit;
    }

    public int getLevelDec(BooleanVarImpl v) {
        return ((BooleanDomain)v.getDomain()).getStoredList().findIndexOfInt(((BooleanDomain)v.getDomain()).getOffset());
    }

    @Override
    public void register(ClauseStore propagator) throws ContradictionException {
        super.register(propagator);
        this.isreg = true;
    }

    @Override
    public boolean isRegistered() {
        return this.isreg;
    }

    @Override
    public boolean learnt() {
        return true;
    }
}

