/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sat;

import choco.cp.solver.constraints.integer.bool.sat.DynWLClause;
import choco.cp.solver.constraints.integer.bool.sat.Lits;
import choco.cp.solver.constraints.integer.bool.sat.Vec;
import choco.cp.solver.constraints.integer.bool.sat.WLClause;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntIntHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class ClauseStore
extends AbstractLargeIntSConstraint {
    public static boolean nonincprop = false;
    protected Lits voc;
    protected LinkedList<WLClause> listclause;
    protected LinkedList<WLClause> listToPropagate;
    protected LinkedList<IntDomainVar> instToOne;
    protected LinkedList<IntDomainVar> instToZero;
    private final TIntIntHashMap indexes;
    protected int[] fineDegree;

    public ClauseStore(IntDomainVar[] vars) {
        this(vars, new LinkedList(), new Lits());
        this.voc.init(vars);
    }

    public ClauseStore(IntDomainVar[] vars, LinkedList listclause, Lits voc) {
        super(vars);
        this.solver = vars[0].getSolver();
        this.voc = voc;
        this.listclause = listclause;
        this.listToPropagate = new LinkedList();
        this.instToOne = new LinkedList();
        this.instToZero = new LinkedList();
        this.fineDegree = new int[vars.length];
        this.indexes = new TIntIntHashMap(vars.length);
        for (int v = 0; v < vars.length; ++v) {
            this.indexes.put(vars[v].getIndexIn(0), v);
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    public Lits getVoc() {
        return this.voc;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (nonincprop) {
            this.constAwake(false);
        } else {
            this.filterOnInst(idx);
        }
    }

    public void filterOnInst(int idx) throws ContradictionException {
        block4: {
            int sidx;
            block3: {
                int val = this.vars[idx].getVal();
                sidx = idx + 1;
                if (val != 1) break block3;
                int vocidx = -sidx;
                Vec<WLClause> wlist = this.voc.watches(vocidx);
                if (wlist == null) break block4;
                for (int i = 0; i < wlist.size(); ++i) {
                    WLClause clause = wlist.get(i);
                    if (!clause.propagate(vocidx, i)) continue;
                    --i;
                }
                break block4;
            }
            Vec<WLClause> wlist = this.voc.watches(sidx);
            if (wlist != null) {
                for (int i = 0; i < wlist.size(); ++i) {
                    WLClause clause = wlist.get(i);
                    if (!clause.propagate(sidx, i)) continue;
                    --i;
                }
            }
        }
    }

    public void addClause(int[] lits) {
        this.listclause.add(new WLClause(lits, this.voc));
    }

    public IntDomainVar[] removeRedundantVars(IntDomainVar[] vs) {
        HashSet<IntDomainVar> filteredVars = new HashSet<IntDomainVar>();
        for (int i = 0; i < vs.length; ++i) {
            if (filteredVars.contains(vs[i])) continue;
            filteredVars.add(vs[i]);
        }
        IntDomainVar[] filteredTab = new IntDomainVar[filteredVars.size()];
        filteredVars.toArray(filteredTab);
        return filteredTab;
    }

    public int[] computeLits(IntDomainVar[] plit, IntDomainVar[] nlit) {
        int lit;
        int i;
        int[] lits = new int[plit.length + nlit.length];
        int cpt = 0;
        for (i = 0; i < plit.length; ++i) {
            lits[cpt] = lit = this.findIndex(plit[i]);
            ++cpt;
        }
        for (i = 0; i < nlit.length; ++i) {
            lit = this.findIndex(nlit[i]);
            lits[cpt] = -lit;
            ++cpt;
        }
        return lits;
    }

    public void updateDegree(int[] lit) {
        for (int i = 0; i < lit.length; ++i) {
            int l;
            int n = l = lit[i] < 0 ? -lit[i] - 1 : lit[i] - 1;
            this.fineDegree[n] = this.fineDegree[n] + 1;
        }
    }

    public void addClause(IntDomainVar[] positivelits, IntDomainVar[] negativelits) {
        IntDomainVar[] plit = this.removeRedundantVars(positivelits);
        IntDomainVar[] nlit = this.removeRedundantVars(negativelits);
        int[] lits = this.computeLits(plit, nlit);
        this.updateDegree(lits);
        if (lits.length == 1) {
            if (plit.length == 1) {
                this.instToOne.add(this.vars[lits[0] - 1]);
            } else {
                this.instToZero.add(this.vars[-lits[0] - 1]);
            }
        } else {
            this.listclause.add(new WLClause(lits, this.voc));
        }
    }

    public int findIndex(IntDomainVar v) {
        return this.indexes.get(v.getIndexIn(0)) + 1;
    }

    public void addDynamicClause(IntDomainVar[] positivelits, IntDomainVar[] negativelits) {
        IntDomainVar[] plit = this.removeRedundantVars(positivelits);
        IntDomainVar[] nlit = this.removeRedundantVars(negativelits);
        int[] lits = this.computeLits(plit, nlit);
        this.updateDegree(lits);
        if (lits.length == 1) {
            if (plit.length == 1) {
                this.instToOne.add(this.vars[lits[0] - 1]);
            } else {
                this.instToZero.add(this.vars[-lits[0] - 1]);
            }
        } else {
            DynWLClause clause = new DynWLClause(lits, this.voc);
            this.listclause.add(clause);
            this.listToPropagate.addLast(clause);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        for (WLClause cl : this.listclause) {
            if (cl.isRegistered()) continue;
            cl.register(this);
        }
        this.propagateUnitClause();
    }

    public void propagateUnitClause() throws ContradictionException {
        for (IntDomainVar v : this.instToOne) {
            v.instantiate(1, -1);
        }
        for (IntDomainVar v : this.instToZero) {
            v.instantiate(0, -1);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (nonincprop) {
            this.filterFromScratch();
        } else {
            Iterator iterator = this.listToPropagate.iterator();
            while (iterator.hasNext()) {
                WLClause cl = (WLClause)iterator.next();
                if (!cl.isRegistered()) {
                    cl.register(this);
                }
                if (cl.update()) continue;
                iterator.remove();
            }
            this.propagateUnitClause();
        }
    }

    public void filterFromScratch() throws ContradictionException {
        for (WLClause cl : this.listclause) {
            cl.simplePropagation(this);
        }
    }

    @Override
    public boolean isSatisfied() {
        for (WLClause cl : this.listclause) {
            if (cl.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getFineDegree(int idx) {
        return this.fineDegree[idx];
    }
}

