/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class LargeOr
extends AbstractLargeIntSConstraint {
    protected int lit1 = Integer.MAX_VALUE;
    protected int lit2 = Integer.MAX_VALUE;

    public LargeOr(IntDomainVar[] vars) {
        super(vars);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void awake() throws ContradictionException {
        this.lit1 = Integer.MAX_VALUE;
        this.lit2 = Integer.MAX_VALUE;
        this.propagate();
    }

    public void initFilterFrombOne() throws ContradictionException {
        boolean updateLit1 = true;
        boolean updateLit2 = true;
        if (this.lit1 != Integer.MAX_VALUE && this.vars[this.lit1].fastCanBeInstantiatedTo(1)) {
            updateLit1 = false;
        }
        if (this.lit2 != Integer.MAX_VALUE && this.vars[this.lit2].fastCanBeInstantiatedTo(1)) {
            updateLit2 = false;
        }
        if (updateLit1 || updateLit2) {
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i].isInstantiatedTo(1)) {
                    this.setEntailed();
                    continue;
                }
                if (this.vars[i].isInstantiated()) continue;
                if (updateLit1 && this.lit1 > i) {
                    this.lit1 = i;
                    continue;
                }
                if (!updateLit2 || this.lit2 <= i) continue;
                this.lit2 = i;
                break;
            }
            if (this.lit1 == Integer.MAX_VALUE) {
                this.fail();
            } else if (this.lit2 == Integer.MAX_VALUE) {
                this.vars[this.lit1].instantiate(1, this.cIndices[this.lit1]);
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.initFilterFrombOne();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = this.vars[idx].getVal();
        if (val == 1) {
            this.setEntailed();
        } else if (idx == this.lit1) {
            for (int i = 0; i < this.vars.length; ++i) {
                if (i == this.lit2 || !this.vars[i].fastCanBeInstantiatedTo(1)) continue;
                this.lit1 = i;
                break;
            }
            if (this.lit1 == idx) {
                this.vars[this.lit2].instantiate(1, this.cIndices[this.lit2]);
            }
        } else if (idx == this.lit2) {
            for (int i = 0; i < this.vars.length; ++i) {
                if (i == this.lit1 || !this.vars[i].fastCanBeInstantiatedTo(1)) continue;
                this.lit2 = i;
                break;
            }
            if (this.lit2 == idx) {
                this.vars[this.lit1].instantiate(1, this.cIndices[this.lit1]);
            }
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 1; i < tuple.length; ++i) {
            if (tuple[i] != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean isEntailed() {
        int i;
        for (i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].isInstantiatedTo(1)) continue;
            return Boolean.TRUE;
        }
        for (i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].fastCanBeInstantiatedTo(1)) continue;
            return null;
        }
        return Boolean.FALSE;
    }
}

