/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class BoolTimesXYZ
extends AbstractTernIntSConstraint {
    public BoolTimesXYZ(IntDomainVar x0, IntDomainVar x1, IntDomainVar x2) {
        super(x0, x1, x2);
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " * " + this.v1.pretty() + " = " + this.v2.pretty();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int val = this.v0.getVal();
            if (val == 0) {
                this.v2.instantiate(0, this.cIdx2);
            } else if (this.v1.isInstantiatedTo(1)) {
                this.v2.instantiate(1, this.cIdx2);
            } else if (this.v2.isInstantiatedTo(0)) {
                this.v1.instantiate(0, this.cIdx1);
            }
        } else if (idx == 1) {
            int val = this.v1.getVal();
            if (val == 0) {
                this.v2.instantiate(0, this.cIdx2);
            } else if (this.v0.isInstantiatedTo(1)) {
                this.v2.instantiate(1, this.cIdx2);
            } else if (this.v2.isInstantiatedTo(0)) {
                this.v0.instantiate(0, this.cIdx0);
            }
        } else if (idx == 2) {
            int val = this.v2.getVal();
            if (val == 1) {
                this.v0.instantiate(1, this.cIdx0);
                this.v1.instantiate(1, this.cIdx1);
            } else if (this.v0.isInstantiatedTo(1)) {
                this.v1.instantiate(0, this.cIdx1);
            } else if (this.v1.isInstantiatedTo(1)) {
                this.v0.instantiate(0, this.cIdx0);
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.awakeOnInst(0);
        }
        if (this.v1.isInstantiated()) {
            this.awakeOnInst(1);
        }
        if (this.v2.isInstantiated()) {
            this.awakeOnInst(2);
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] * tuple[1] == tuple[2];
    }

    @Override
    public Boolean isEntailed() {
        if (this.v2.isInstantiatedTo(0)) {
            if (this.v0.isInstantiatedTo(0) || this.v1.isInstantiatedTo(0)) {
                return Boolean.TRUE;
            }
            if (this.v0.isInstantiatedTo(1) && this.v1.isInstantiatedTo(1)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.v2.isInstantiatedTo(1)) {
            if (this.v0.isInstantiatedTo(0) || this.v1.isInstantiatedTo(0)) {
                return Boolean.FALSE;
            }
            if (this.v0.isInstantiatedTo(1) && this.v1.isInstantiatedTo(1)) {
                return Boolean.TRUE;
            }
            return null;
        }
        return null;
    }
}

