/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class BoolSum
extends AbstractLargeIntSConstraint {
    protected IStateInt nbz;
    protected IStateInt nbo;
    protected int op;
    protected int gap;

    public BoolSum(IntDomainVar[] vars, int coef, int op) {
        super(vars);
        this.solver = vars[0].getSolver();
        this.cste = coef;
        this.op = op;
        this.gap = vars.length - this.cste;
        this.nbz = this.solver.getEnvironment().makeInt(0);
        this.nbo = this.solver.getEnvironment().makeInt(0);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.cste == 0 && (this.op == 0 || this.op == 3)) {
            for (int i = 0; i < this.vars.length; ++i) {
                this.vars[i].instantiate(0, this.cIndices[i]);
            }
        } else if (this.cste == this.vars.length && (this.op == 0 || this.op == 1)) {
            for (int i = 0; i < this.vars.length; ++i) {
                this.vars[i].instantiate(1, this.cIndices[i]);
            }
        } else {
            this.nbz.set(0);
            this.nbo.set(0);
            for (int i = 0; i < this.vars.length; ++i) {
                if (!this.vars[i].isInstantiated()) continue;
                this.awakeOnInst(i);
            }
        }
    }

    public void putAllZero() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            this.vars[i].instantiate(0, this.cIndices[i]);
        }
    }

    public void putAllOne() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            this.vars[i].instantiate(1, this.cIndices[i]);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = this.vars[idx].getVal();
        if (val == 0) {
            this.nbz.add(1);
        } else {
            this.nbo.add(1);
        }
        if (this.op == 1) {
            if (this.nbo.get() >= this.cste) {
                this.setEntailed();
            } else if (this.nbz.get() > this.gap) {
                this.fail();
            } else if (this.nbz.get() == this.gap) {
                this.putAllOne();
            }
        } else if (this.op == 3) {
            if (this.nbz.get() >= this.gap) {
                this.setEntailed();
            } else if (this.nbo.get() > this.cste) {
                this.fail();
            } else if (this.nbo.get() == this.cste) {
                this.putAllZero();
            }
        } else if (this.op == 0) {
            if (this.nbo.get() > this.cste || this.nbz.get() > this.gap) {
                this.fail();
            }
            if (this.nbo.get() == this.cste) {
                this.putAllZero();
            } else if (this.nbz.get() == this.gap) {
                this.putAllOne();
            }
        } else if (this.op == 2) {
            throw new SolverException("Neq operator not ready for BoolIntLinComb");
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int s = 0;
        for (int i = 0; i < tuple.length; ++i) {
            s += tuple[i];
        }
        if (this.op == 1) {
            return s >= this.cste;
        }
        if (this.op == 3) {
            return s <= this.cste;
        }
        if (this.op == 0) {
            return s == this.cste;
        }
        if (this.op == 2) {
            return s != this.cste;
        }
        throw new SolverException("operator unknown for BoolIntLinComb");
    }

    @Override
    public AbstractSConstraint opposite() {
        IntDomainVar[] bvs = new IntDomainVar[this.vars.length];
        System.arraycopy(this.vars, 0, bvs, 0, this.vars.length);
        if (this.op == 0) {
            return new BoolSum(bvs, this.cste, 2);
        }
        if (this.op == 2) {
            return new BoolSum(bvs, this.cste, 0);
        }
        if (this.op == 1) {
            return new BoolSum(bvs, this.cste - 1, 3);
        }
        if (this.op == 3) {
            return new BoolSum(bvs, this.cste + 1, 1);
        }
        throw new SolverException("operator unknown for BoolIntLinComb");
    }

    protected int computeUbFromScratch() {
        int s = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            s += this.vars[i].getSup();
        }
        return s;
    }

    protected int computeLbFromScratch() {
        int s = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            s += this.vars[i].getInf();
        }
        return s;
    }

    @Override
    public Boolean isEntailed() {
        if (this.op == 0) {
            int lb = this.computeLbFromScratch();
            int ub = this.computeUbFromScratch();
            if (lb > this.cste || ub < this.cste) {
                return Boolean.FALSE;
            }
            if (lb == ub && this.cste == lb) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.op == 1) {
            if (this.computeLbFromScratch() >= this.cste) {
                return Boolean.TRUE;
            }
            if (this.computeUbFromScratch() < this.cste) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.op == 3) {
            if (this.computeUbFromScratch() <= this.cste) {
                return Boolean.TRUE;
            }
            if (this.computeLbFromScratch() > this.cste) {
                return Boolean.FALSE;
            }
            return null;
        }
        throw new SolverException("NEQ not managed by boolIntLinComb");
    }
}

