/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class BoolIntLinComb
extends AbstractLargeIntSConstraint {
    protected int op = -1;
    protected IStateInt lb;
    protected IStateInt ub;
    protected IStateInt maxPosCoeff;
    protected IStateInt maxNegCoeff;
    protected int[] sCoeffs;
    protected int nbNegCoef;
    protected int objCoef;
    protected int addcste;
    protected RightMemberBounds rmemb;
    final IntDomainVarImpl varCste;

    public static IntDomainVar[] makeTableVar(IntDomainVar[] vs, IntDomainVar v) {
        IntDomainVar[] nvars = new IntDomainVar[vs.length + 1];
        System.arraycopy(vs, 0, nvars, 0, vs.length);
        nvars[vs.length] = v;
        return nvars;
    }

    public BoolIntLinComb(IntDomainVar[] vs, int[] coefs, IntDomainVar c, int objcoef, int scste, int op) {
        super(BoolIntLinComb.makeTableVar(vs, c));
        this.sCoeffs = coefs;
        this.op = op;
        this.cste = vs.length;
        this.varCste = (IntDomainVarImpl)this.vars[this.cste];
        this.objCoef = objcoef;
        this.addcste = scste;
        this.solver = this.vars[0].getSolver();
        this.nbNegCoef = 0;
        while (this.nbNegCoef < this.cste && this.sCoeffs[this.nbNegCoef] < 0) {
            ++this.nbNegCoef;
        }
        if (op == 0 || op == 1 || op == 3) {
            this.maxPosCoeff = this.solver.getEnvironment().makeInt();
            this.maxNegCoeff = this.solver.getEnvironment().makeInt();
        }
        if (op == 0 || op == 1) {
            this.ub = this.solver.getEnvironment().makeInt();
        }
        if (op == 0 || op == 3) {
            this.lb = this.solver.getEnvironment().makeInt();
        }
        this.rmemb = this.objCoef == 1 ? new SimpleRightMemberBounds() : new RightMemberBounds();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx < this.cste) {
            return 8;
        }
        return 11;
    }

    public static int divCeil(int a, int b) {
        return (int)Math.ceil((double)a / (double)b);
    }

    public static int divFloor(int a, int b) {
        return (int)Math.floor((double)a / (double)b);
    }

    public void updateUbLbOnInst(int idx, int i) {
        if (this.sCoeffs[idx] < 0) {
            if (i == 1) {
                this.ub.add(this.sCoeffs[idx]);
            } else {
                this.lb.add(-this.sCoeffs[idx]);
            }
        } else if (i == 1) {
            this.lb.add(this.sCoeffs[idx]);
        } else {
            this.ub.add(-this.sCoeffs[idx]);
        }
    }

    public void lookForNewMaxPosCoeff() {
        int i;
        for (i = this.maxPosCoeff.get() - 1; i >= this.nbNegCoef && this.vars[i].isInstantiated(); --i) {
        }
        this.maxPosCoeff.set(i);
    }

    public void lookForNewMaxNegCoeff() {
        int i;
        for (i = this.maxNegCoeff.get() + 1; i < this.nbNegCoef && this.vars[i].isInstantiated(); ++i) {
        }
        this.maxNegCoeff.set(i);
    }

    public boolean updateForGEQ() throws ContradictionException {
        boolean change = false;
        change |= this.filterPosCoeffUb();
        return change |= this.filterNegCoeffUb();
    }

    public boolean updateForLEQ() throws ContradictionException {
        boolean change = false;
        change |= this.filterPosCoeffLb();
        return change |= this.filterNegCoeffLb();
    }

    public void fixPointOnEQ() throws ContradictionException {
        for (boolean fixpoint = true; fixpoint; fixpoint |= this.updateForLEQ()) {
            fixpoint = false;
            this.varCste.updateSup(this.rmemb.getNewSupForObj(), this.cIndices[this.cste]);
            this.varCste.updateInf(this.rmemb.getNewInfForObj(), this.cIndices[this.cste]);
            fixpoint |= this.updateForGEQ();
        }
    }

    public boolean filterNegCoeffUb() throws ContradictionException {
        int cpt;
        boolean change = false;
        for (cpt = this.maxNegCoeff.get(); cpt < this.nbNegCoef && this.vars[cpt].isInstantiated(); ++cpt) {
        }
        while (cpt < this.nbNegCoef && this.ub.get() + this.sCoeffs[cpt] < this.rmemb.getInfRight()) {
            IntDomainVarImpl v = (IntDomainVarImpl)this.vars[cpt];
            v.instantiate(0, this.cIndices[cpt]);
            change = true;
            if (this.op == 0) {
                this.lb.add(-this.sCoeffs[cpt]);
            }
            while (++cpt < this.nbNegCoef && this.vars[cpt].isInstantiated()) {
            }
        }
        this.maxNegCoeff.set(cpt);
        return change;
    }

    public boolean filterPosCoeffUb() throws ContradictionException {
        int cpt;
        boolean change = false;
        for (cpt = this.maxPosCoeff.get(); cpt >= this.nbNegCoef && this.vars[cpt].isInstantiated(); --cpt) {
        }
        while (cpt >= this.nbNegCoef && this.ub.get() - this.sCoeffs[cpt] < this.rmemb.getInfRight()) {
            IntDomainVarImpl v = (IntDomainVarImpl)this.vars[cpt];
            v.instantiate(1, this.cIndices[cpt]);
            change = true;
            if (this.op == 0) {
                this.lb.add(this.sCoeffs[cpt]);
            }
            while (--cpt >= this.nbNegCoef && this.vars[cpt].isInstantiated()) {
            }
        }
        this.maxPosCoeff.set(cpt);
        return change;
    }

    public boolean filterPosCoeffLb() throws ContradictionException {
        int cpt;
        boolean change = false;
        for (cpt = this.maxPosCoeff.get(); cpt >= this.nbNegCoef && this.vars[cpt].isInstantiated(); --cpt) {
        }
        while (cpt >= this.nbNegCoef && this.lb.get() + this.sCoeffs[cpt] > this.rmemb.getSupRight()) {
            this.vars[cpt].instantiate(0, this.cIndices[cpt]);
            change = true;
            if (this.op == 0) {
                this.ub.add(-this.sCoeffs[cpt]);
            }
            while (--cpt >= this.nbNegCoef && this.vars[cpt].isInstantiated()) {
            }
        }
        this.maxPosCoeff.set(cpt);
        return change;
    }

    public boolean filterNegCoeffLb() throws ContradictionException {
        int cpt;
        boolean change = false;
        for (cpt = this.maxNegCoeff.get(); cpt < this.nbNegCoef && this.vars[cpt].isInstantiated(); ++cpt) {
        }
        while (cpt < this.nbNegCoef && this.lb.get() - this.sCoeffs[cpt] > this.rmemb.getSupRight()) {
            this.vars[cpt].instantiate(1, this.cIndices[cpt]);
            change = true;
            if (this.op == 0) {
                this.ub.add(this.sCoeffs[cpt]);
            }
            while (++cpt < this.nbNegCoef && this.vars[cpt].isInstantiated()) {
            }
        }
        this.maxNegCoeff.set(cpt);
        return change;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.cste) {
            int i = this.vars[idx].getVal();
            if (this.op == 1) {
                if (this.sCoeffs[idx] < 0 && i == 1) {
                    this.ub.add(this.sCoeffs[idx]);
                    this.varCste.updateSup(this.rmemb.getNewSupForObj(), this.cIndices[this.cste]);
                    this.updateForGEQ();
                } else if (this.sCoeffs[idx] > 0 && i == 0) {
                    this.ub.add(-this.sCoeffs[idx]);
                    this.varCste.updateSup(this.rmemb.getNewSupForObj(), this.cIndices[this.cste]);
                    this.updateForGEQ();
                } else if (idx == this.maxPosCoeff.get()) {
                    this.lookForNewMaxPosCoeff();
                } else if (idx == this.maxNegCoeff.get()) {
                    this.lookForNewMaxNegCoeff();
                }
            } else if (this.op == 3) {
                if (this.sCoeffs[idx] > 0 && i == 1) {
                    this.lb.add(this.sCoeffs[idx]);
                    this.varCste.updateInf(this.rmemb.getNewInfForObj(), this.cIndices[this.cste]);
                    this.updateForLEQ();
                } else if (this.sCoeffs[idx] < 0 && i == 0) {
                    this.lb.add(-this.sCoeffs[idx]);
                    this.varCste.updateInf(this.rmemb.getNewInfForObj(), this.cIndices[this.cste]);
                    this.updateForLEQ();
                } else if (idx == this.maxPosCoeff.get()) {
                    this.lookForNewMaxPosCoeff();
                } else if (idx == this.maxNegCoeff.get()) {
                    this.lookForNewMaxNegCoeff();
                }
            } else if (this.op == 0) {
                this.updateUbLbOnInst(idx, i);
                this.fixPointOnEQ();
            }
        } else if (this.op == 1) {
            this.filterPosCoeffUb();
            this.filterNegCoeffUb();
        } else if (this.op == 0) {
            this.fixPointOnEQ();
        } else if (this.op == 3) {
            this.filterPosCoeffLb();
            this.filterNegCoeffLb();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.op == 1) {
            this.filterPosCoeffUb();
            this.filterNegCoeffUb();
        } else if (this.op == 0) {
            this.fixPointOnEQ();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.op == 0) {
            this.fixPointOnEQ();
        } else if (this.op == 3) {
            this.filterPosCoeffLb();
            this.filterNegCoeffLb();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.op == 1 || this.op == 0 || this.op == 3) {
            this.maxNegCoeff.set(0);
            this.maxPosCoeff.set(this.cste - 1);
        }
        if (this.op == 2) {
            // empty if block
        }
        if (this.op == 1 || this.op == 0) {
            this.initUb();
        }
        if (this.op == 0 || this.op == 3) {
            this.initlb();
        }
        if (this.op == 0) {
            this.propagateEQ();
        } else if (this.op == 1) {
            this.propagateGEQ();
        } else if (this.op == 3) {
            this.propagateLEQ();
        }
    }

    public void propagateEQ() throws ContradictionException {
        int i;
        for (i = 0; i < this.nbNegCoef; ++i) {
            if (this.ub.get() + this.sCoeffs[i] >= this.rmemb.getInfRight()) continue;
            this.vars[i].instantiate(0, this.cIndices[i]);
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            if (this.ub.get() - this.sCoeffs[i] >= this.rmemb.getInfRight()) continue;
            this.vars[i].instantiate(1, this.cIndices[i]);
        }
        for (i = 0; i < this.nbNegCoef; ++i) {
            if (this.lb.get() - this.sCoeffs[i] <= this.rmemb.getSupRight()) continue;
            this.vars[i].instantiate(1, this.cIndices[i]);
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            if (this.lb.get() + this.sCoeffs[i] <= this.rmemb.getSupRight()) continue;
            this.vars[i].instantiate(0, this.cIndices[i]);
        }
        for (i = 0; i < this.cste; ++i) {
            if (!this.vars[i].isInstantiated()) continue;
            this.updateUbLbOnInst(i, this.vars[i].getVal());
        }
        this.fixPointOnEQ();
    }

    public void propagateGEQ() throws ContradictionException {
        int i;
        for (i = 0; i < this.nbNegCoef; ++i) {
            if (this.ub.get() + this.sCoeffs[i] < this.rmemb.getInfRight()) {
                this.vars[i].instantiate(0, this.cIndices[i]);
            }
            if (!this.vars[i].isInstantiated()) continue;
            this.awakeOnInst(i);
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            if (this.ub.get() - this.sCoeffs[i] < this.rmemb.getInfRight()) {
                this.vars[i].instantiate(1, this.cIndices[i]);
            }
            if (!this.vars[i].isInstantiated()) continue;
            this.awakeOnInst(i);
        }
        this.varCste.updateSup(this.rmemb.getNewSupForObj(), this.cIndices[this.cste]);
        this.updateForGEQ();
    }

    public void propagateLEQ() throws ContradictionException {
        int i;
        for (i = 0; i < this.nbNegCoef; ++i) {
            if (this.lb.get() - this.sCoeffs[i] > this.rmemb.getSupRight()) {
                this.vars[i].instantiate(1, -1);
            }
            if (!this.vars[i].isInstantiated()) continue;
            this.awakeOnInst(i);
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            if (this.lb.get() + this.sCoeffs[i] > this.rmemb.getSupRight()) {
                this.vars[i].instantiate(0, -1);
            }
            if (!this.vars[i].isInstantiated()) continue;
            this.awakeOnInst(i);
        }
        this.varCste.updateInf(this.rmemb.getNewInfForObj(), this.cIndices[this.cste]);
        this.updateForLEQ();
    }

    public void initUb() {
        int upb = this.addcste;
        for (int i = 0; i < this.sCoeffs.length; ++i) {
            if (this.sCoeffs[i] <= 0) continue;
            upb += this.sCoeffs[i];
        }
        this.ub.set(upb);
    }

    public void initlb() {
        int lpb = this.addcste;
        for (int i = 0; i < this.sCoeffs.length; ++i) {
            if (this.sCoeffs[i] >= 0) continue;
            lpb += this.sCoeffs[i];
        }
        this.lb.set(lpb);
    }

    @Override
    public boolean isConsistent() {
        if (this.op == 0) {
            return this.hasConsistentLowerBound() && this.hasConsistentUpperBound();
        }
        if (this.op == 1) {
            return this.hasConsistentUpperBound();
        }
        if (this.op == 3) {
            return this.hasConsistentLowerBound();
        }
        return true;
    }

    protected boolean hasConsistentUpperBound() {
        int i;
        if (this.ub.get() < this.rmemb.getInfRight()) {
            return false;
        }
        for (i = 0; i < this.nbNegCoef; ++i) {
            if (this.ub.get() + this.vars[i].getSup() * this.sCoeffs[i] >= this.rmemb.getInfRight()) continue;
            return false;
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            if (this.ub.get() - this.vars[i].getInf() * this.sCoeffs[i] >= this.rmemb.getInfRight()) continue;
            return false;
        }
        return true;
    }

    protected boolean hasConsistentLowerBound() {
        int i;
        if (this.lb.get() > this.rmemb.getSupRight()) {
            return false;
        }
        for (i = 0; i < this.nbNegCoef; ++i) {
            if (this.lb.get() - this.vars[i].getInf() * this.sCoeffs[i] <= this.rmemb.getSupRight()) continue;
            return false;
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            if (this.lb.get() + this.vars[i].getSup() * this.sCoeffs[i] <= this.rmemb.getSupRight()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean isEntailed() {
        if (this.op == 0) {
            int lb = this.computeLbFromScratch();
            int ub = this.computeUbFromScratch();
            int cstelb = this.objCoef * this.varCste.getInf();
            int csteub = this.objCoef * this.varCste.getSup();
            if (lb > csteub || ub < cstelb) {
                return Boolean.FALSE;
            }
            if (lb == ub && this.varCste.isInstantiated() && this.objCoef * this.varCste.getVal() == lb) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.op == 1) {
            if (this.computeLbFromScratch() >= this.rmemb.getSupRight()) {
                return Boolean.TRUE;
            }
            if (this.computeUbFromScratch() < this.rmemb.getInfRight()) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.op == 3) {
            if (this.computeUbFromScratch() <= this.rmemb.getInfRight()) {
                return Boolean.TRUE;
            }
            if (this.computeLbFromScratch() > this.rmemb.getSupRight()) {
                return Boolean.FALSE;
            }
            return null;
        }
        throw new SolverException("NEQ not managed by boolIntLinComb");
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int exp = 0;
        for (int i = 0; i < this.cste; ++i) {
            exp += tuple[i] * this.sCoeffs[i];
        }
        if (this.op == 1) {
            return exp + this.addcste >= this.objCoef * tuple[this.cste];
        }
        if (this.op == 3) {
            return exp + this.addcste <= this.objCoef * tuple[this.cste];
        }
        if (this.op == 0) {
            return exp + this.addcste == this.objCoef * tuple[this.cste];
        }
        if (this.op == 2) {
            return exp + this.addcste != this.objCoef * tuple[this.cste];
        }
        throw new SolverException("operator unknown for BoolIntLinComb");
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.cste; ++i) {
            if (i > 0) {
                sb.append(" + ");
            }
            sb.append(this.sCoeffs[i]).append("*").append(this.vars[i].pretty());
        }
        sb.append(" + ").append(this.addcste);
        switch (this.op) {
            case 1: {
                sb.append(" >= ");
                break;
            }
            case 3: {
                sb.append(" <= ");
                break;
            }
            case 0: {
                sb.append(" = ");
                break;
            }
            case 2: {
                sb.append(" != ");
                break;
            }
            default: {
                sb.append(" ??? ");
            }
        }
        sb.append(this.objCoef).append("*").append(this.varCste.pretty());
        return sb.toString();
    }

    @Override
    public AbstractSConstraint opposite() {
        IntDomainVar[] bvs = new IntDomainVar[this.cste];
        System.arraycopy(this.vars, 0, bvs, 0, this.cste);
        if (this.op == 0) {
            IntDomainVar[] vs = new IntDomainVar[this.vars.length];
            System.arraycopy(this.vars, 0, vs, 0, this.vars.length);
            int[] coeff = new int[this.cste + 1];
            System.arraycopy(this.sCoeffs, 0, coeff, 0, this.cste);
            coeff[this.cste] = -this.objCoef;
            return (AbstractSConstraint)this.solver.neq(this.solver.scalar(vs, coeff), -this.addcste);
        }
        if (this.op == 2) {
            return new BoolIntLinComb(bvs, this.sCoeffs, this.varCste, this.objCoef, this.addcste, 0);
        }
        if (this.op == 1) {
            return new BoolIntLinComb(bvs, this.sCoeffs, this.varCste, this.objCoef, this.addcste + 1, 3);
        }
        if (this.op == 3) {
            return new BoolIntLinComb(bvs, this.sCoeffs, this.varCste, this.objCoef, this.addcste - 1, 1);
        }
        throw new SolverException("operator unknown for BoolIntLinComb");
    }

    protected int computeUbFromScratch() {
        int i;
        int s = this.addcste;
        for (i = 0; i < this.nbNegCoef; ++i) {
            s += this.vars[i].getInf() * this.sCoeffs[i];
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            s += this.vars[i].getSup() * this.sCoeffs[i];
        }
        return s;
    }

    protected int computeLbFromScratch() {
        int i;
        int s = this.addcste;
        for (i = 0; i < this.nbNegCoef; ++i) {
            s += this.vars[i].getSup() * this.sCoeffs[i];
        }
        for (i = this.nbNegCoef; i < this.cste; ++i) {
            s += this.vars[i].getInf() * this.sCoeffs[i];
        }
        return s;
    }

    public class SimpleRightMemberBounds
    extends RightMemberBounds {
        @Override
        public int getInfRight() {
            return BoolIntLinComb.this.varCste.getInf();
        }

        @Override
        public int getSupRight() {
            return BoolIntLinComb.this.varCste.getSup();
        }

        @Override
        public int getNewInfForObj() {
            return BoolIntLinComb.this.lb.get();
        }

        @Override
        public int getNewSupForObj() {
            return BoolIntLinComb.this.ub.get();
        }
    }

    public class RightMemberBounds {
        public int getInfRight() {
            return BoolIntLinComb.this.objCoef * BoolIntLinComb.this.varCste.getInf();
        }

        public int getSupRight() {
            return BoolIntLinComb.this.objCoef * BoolIntLinComb.this.varCste.getSup();
        }

        public int getNewInfForObj() {
            return BoolIntLinComb.divCeil(BoolIntLinComb.this.lb.get(), BoolIntLinComb.this.objCoef);
        }

        public int getNewSupForObj() {
            return BoolIntLinComb.divFloor(BoolIntLinComb.this.ub.get(), BoolIntLinComb.this.objCoef);
        }
    }
}

