/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.Arithm;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class TimesXYZ
extends AbstractTernIntSConstraint {
    public TimesXYZ(IntDomainVar x, IntDomainVar y, IntDomainVar z) {
        super(x, y, z);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] * tuple[1] == tuple[2];
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " * " + this.v1.pretty() + " = " + this.v2.pretty();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.awakeOnX();
        } else if (idx == 1) {
            this.awakeOnY();
        } else if (idx == 2) {
            this.awakeOnZ();
            if (!this.v2.canBeInstantiatedTo(0)) {
                this.v2.updateSup(this.getZmax(), this.cIdx2);
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.awakeOnX();
        } else if (idx == 1) {
            this.awakeOnY();
        } else if (idx == 2) {
            this.awakeOnZ();
            if (!this.v2.canBeInstantiatedTo(0)) {
                this.v2.updateInf(this.getZmin(), this.cIdx2);
            }
        }
    }

    public void filter(int idx) throws ContradictionException {
        if (idx == 0) {
            this.awakeOnX();
        } else if (idx == 1) {
            this.awakeOnY();
        } else if (idx == 2) {
            this.awakeOnZ();
        }
    }

    @Override
    public void awakeOnInst(int vIdx) throws ContradictionException {
        this.filter(vIdx);
    }

    protected void awakeOnX() throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.v2.instantiate(0, this.cIdx2);
        }
        if (this.v2.isInstantiatedTo(0) && !this.v0.canBeInstantiatedTo(0)) {
            this.v1.instantiate(0, this.cIdx1);
        } else if (!this.v2.canBeInstantiatedTo(0)) {
            this.updateYandX();
        } else if (!this.v2.isInstantiatedTo(0)) {
            this.shaveOnYandX();
        }
        if (!this.v2.isInstantiatedTo(0)) {
            this.v2.updateInf(this.getZmin(), this.cIdx2);
            this.v2.updateSup(this.getZmax(), this.cIdx2);
        }
    }

    protected void awakeOnY() throws ContradictionException {
        if (this.v1.isInstantiatedTo(0)) {
            this.v2.instantiate(0, this.cIdx2);
        }
        if (this.v2.isInstantiatedTo(0) && !this.v1.canBeInstantiatedTo(0)) {
            this.v0.instantiate(0, this.cIdx0);
        } else if (!this.v2.canBeInstantiatedTo(0)) {
            this.updateXandY();
        } else if (!this.v2.isInstantiatedTo(0)) {
            this.shaveOnXandY();
        }
        if (!this.v2.isInstantiatedTo(0)) {
            this.v2.updateInf(this.getZmin(), this.cIdx2);
            this.v2.updateSup(this.getZmax(), this.cIdx2);
        }
    }

    protected void awakeOnZ() throws ContradictionException {
        if (!this.v2.canBeInstantiatedTo(0)) {
            this.updateX();
            if (this.updateY()) {
                this.updateXandY();
            }
        } else if (!this.v2.isInstantiatedTo(0)) {
            this.shaveOnX();
            if (this.shaveOnY()) {
                this.shaveOnXandY();
            }
        }
        if (this.v2.isInstantiatedTo(0)) {
            this.propagateZero();
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.isCompletelyInstantiated() && this.isSatisfied()) {
            return Boolean.TRUE;
        }
        if (this.v2.isInstantiatedTo(0)) {
            if (this.v0.isInstantiatedTo(0) || this.v1.isInstantiatedTo(0)) {
                return Boolean.TRUE;
            }
            if (!this.v0.canBeInstantiatedTo(0) && !this.v1.canBeInstantiatedTo(0)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (!this.v2.canBeInstantiatedTo(0)) {
            if (this.v0.getSup() < this.getXminIfNonZero()) {
                return Boolean.FALSE;
            }
            if (this.v0.getInf() > this.getXmaxIfNonZero()) {
                return Boolean.FALSE;
            }
            if (this.v1.getSup() < this.getYminIfNonZero()) {
                return Boolean.FALSE;
            }
            if (this.v1.getInf() > this.getYmaxIfNonZero()) {
                return Boolean.FALSE;
            }
            return null;
        }
        return null;
    }

    protected int getXminIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleA1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.ruleB1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleC1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.ruleD1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleE1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleF1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleG1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleH1(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleI1(this.v0, this.v2, this.v1);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected int getXmaxIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleA2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.ruleB2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleC2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.ruleD2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleE2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleF2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleG2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleH2(this.v0, this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleI2(this.v0, this.v2, this.v1);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected int getYminIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v0.getInf() >= 0) {
            return this.ruleA1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getSup() <= 0) {
            return this.ruleB1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getSup() <= 0) {
            return this.ruleC1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() >= 0) {
            return this.ruleD1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getSup() <= 0) {
            return this.ruleE1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.ruleF1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() >= 0) {
            return this.ruleG1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.ruleH1(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.ruleI1(this.v1, this.v2, this.v0);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected int getYmaxIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v0.getInf() >= 0) {
            return this.ruleA2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getSup() <= 0) {
            return this.ruleB2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getSup() <= 0) {
            return this.ruleC2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() >= 0) {
            return this.ruleD2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getSup() <= 0) {
            return this.ruleE2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.ruleF2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() >= 0) {
            return this.ruleG2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.ruleH2(this.v1, this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.ruleI2(this.v1, this.v2, this.v0);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected int getZmin() {
        if (this.v0.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleA3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.ruleB3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleC3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.ruleD3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleE3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleF3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleG3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleH3(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleI3(this.v2, this.v0, this.v1);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected int getZmax() {
        if (this.v0.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleA4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.ruleB4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleC4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.ruleD4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.ruleE4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleF4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.ruleG4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleH4(this.v2, this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.ruleI4(this.v2, this.v0, this.v1);
        }
        throw new SolverException("None of the cases is active!");
    }

    private int ruleA1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilmM(a, b, c);
    }

    private int ruleB1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilMm(a, b, c);
    }

    private int ruleC1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilMM(a, b, c);
    }

    private int ruleD1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilmm(a, b, c);
    }

    private int ruleE1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilMM(a, b, c);
    }

    private int ruleF1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilmP(a, b, c);
    }

    private int ruleG1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilmm(a, b, c);
    }

    private int ruleH1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilMN(a, b, c);
    }

    private int ruleI1(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infCeilxx(a, b, c);
    }

    private int ruleA2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilMm(a, b, c);
    }

    private int ruleB2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilmM(a, b, c);
    }

    private int ruleC2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilmm(a, b, c);
    }

    private int ruleD2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilMM(a, b, c);
    }

    private int ruleE2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilmM(a, b, c);
    }

    private int ruleF2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilmN(a, b, c);
    }

    private int ruleG2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilMm(a, b, c);
    }

    private int ruleH2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilMP(a, b, c);
    }

    private int ruleI2(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supCeilEq(a, b, c);
    }

    private int ruleA3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloormm(a, b, c);
    }

    private int ruleB3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloorMM(a, b, c);
    }

    private int ruleC3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloorMm(a, b, c);
    }

    private int ruleD3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloormM(a, b, c);
    }

    private int ruleE3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloorMm(a, b, c);
    }

    private int ruleF3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloormM(a, b, c);
    }

    private int ruleG3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloormM(a, b, c);
    }

    private int ruleH3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloorMm(a, b, c);
    }

    private int ruleI3(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.infFloorxx(a, b, c);
    }

    private int ruleA4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloorMM(a, b, c);
    }

    private int ruleB4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloormm(a, b, c);
    }

    private int ruleC4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloormM(a, b, c);
    }

    private int ruleD4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloorMm(a, b, c);
    }

    private int ruleE4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloormm(a, b, c);
    }

    private int ruleF4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloormm(a, b, c);
    }

    private int ruleG4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloorMM(a, b, c);
    }

    private int ruleH4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloorMM(a, b, c);
    }

    private int ruleI4(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return this.supFloorEq(a, b, c);
    }

    private int infFloormm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getInf();
    }

    private int infFloormM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getSup();
    }

    private int infFloorMm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getInf();
    }

    private int infFloorMM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getSup();
    }

    private int supFloormm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getInf();
    }

    private int supFloormM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getSup();
    }

    private int supFloorMm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getInf();
    }

    private int supFloorMM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getSup();
    }

    private int getMinPositive(IntDomainVar v) {
        return 1;
    }

    private int getMaxNegative(IntDomainVar v) {
        return -1;
    }

    private int getNonZeroSup(IntDomainVar v) {
        return Arithm.min(v.getSup(), -1);
    }

    private int getNonZeroInf(IntDomainVar v) {
        return Arithm.max(v.getInf(), 1);
    }

    private int infCeilmm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divCeil(b.getInf(), this.getNonZeroInf(c));
    }

    private int infCeilmM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divCeil(this.getNonZeroInf(b), c.getSup());
    }

    private int infCeilMm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divCeil(this.getNonZeroSup(b), c.getInf());
    }

    private int infCeilMM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divCeil(b.getSup(), this.getNonZeroSup(c));
    }

    private int infCeilmP(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divCeil(b.getInf(), this.getMinPositive(c));
    }

    private int infCeilMN(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divCeil(b.getSup(), this.getMaxNegative(c));
    }

    private int supCeilmm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divFloor(this.getNonZeroInf(b), c.getInf());
    }

    private int supCeilmM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divFloor(b.getInf(), this.getNonZeroSup(c));
    }

    private int supCeilMm(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divFloor(b.getSup(), this.getNonZeroInf(c));
    }

    private int supCeilMM(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divFloor(this.getNonZeroSup(b), c.getSup());
    }

    private int supCeilmN(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divFloor(b.getInf(), this.getMaxNegative(c));
    }

    private int supCeilMP(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.divFloor(b.getSup(), this.getMinPositive(c));
    }

    private int infFloorxx(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        if (b.getInf() * c.getSup() < b.getSup() * c.getInf()) {
            return b.getInf() * c.getSup();
        }
        return b.getSup() * c.getInf();
    }

    private int supFloorEq(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        if (b.getInf() * c.getInf() > b.getSup() * c.getSup()) {
            return b.getInf() * c.getInf();
        }
        return b.getSup() * c.getSup();
    }

    private int infCeilxx(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.min(Arithm.divCeil(b.getInf(), this.getMinPositive(c)), Arithm.divCeil(b.getSup(), this.getMaxNegative(c)));
    }

    private int supCeilEq(IntDomainVar a, IntDomainVar b, IntDomainVar c) {
        return Arithm.max(Arithm.divFloor(b.getInf(), this.getMaxNegative(c)), Arithm.divFloor(b.getSup(), this.getMinPositive(c)));
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter(0);
        this.filter(1);
        this.filter(2);
    }

    public void propagateZero() throws ContradictionException {
        if (!this.v1.canBeInstantiatedTo(0)) {
            this.v0.instantiate(0, this.cIdx0);
        }
        if (!this.v0.canBeInstantiatedTo(0)) {
            this.v1.instantiate(0, this.cIdx1);
        }
    }

    protected boolean updateX() throws ContradictionException {
        boolean infChange = this.v0.updateInf(this.getXminIfNonZero(), this.cIdx0);
        boolean supChange = this.v0.updateSup(this.getXmaxIfNonZero(), this.cIdx0);
        return infChange || supChange;
    }

    protected boolean updateY() throws ContradictionException {
        boolean infChange = this.v1.updateInf(this.getYminIfNonZero(), this.cIdx1);
        boolean supChange = this.v1.updateSup(this.getYmaxIfNonZero(), this.cIdx1);
        return infChange || supChange;
    }

    protected void updateXandY() throws ContradictionException {
        while (this.updateX() && this.updateY()) {
        }
    }

    protected void updateYandX() throws ContradictionException {
        while (this.updateY() && this.updateX()) {
        }
    }

    protected boolean shaveOnX() throws ContradictionException {
        int xmin = this.getXminIfNonZero();
        int xmax = this.getXmaxIfNonZero();
        if (xmin > this.v0.getSup() || xmax < this.v0.getInf()) {
            this.v2.instantiate(0, this.cIdx2);
            this.propagateZero();
            return false;
        }
        boolean infChange = !this.v1.canBeInstantiatedTo(0) && this.v0.updateInf(Arithm.min(0, xmin), this.cIdx0);
        boolean supChange = !this.v1.canBeInstantiatedTo(0) && this.v0.updateSup(Arithm.max(0, xmax), this.cIdx0);
        return infChange || supChange;
    }

    protected boolean shaveOnY() throws ContradictionException {
        int ymin = this.getYminIfNonZero();
        int ymax = this.getYmaxIfNonZero();
        if (ymin > this.v1.getSup() || ymax < this.v1.getInf()) {
            this.v2.instantiate(0, this.cIdx2);
            this.propagateZero();
            return false;
        }
        boolean infChange = !this.v0.canBeInstantiatedTo(0) && this.v1.updateInf(Arithm.min(0, ymin), this.cIdx1);
        boolean supChange = !this.v0.canBeInstantiatedTo(0) && this.v1.updateSup(Arithm.max(0, ymax), this.cIdx1);
        return infChange || supChange;
    }

    protected void shaveOnXandY() throws ContradictionException {
        while (this.shaveOnX() && this.shaveOnY()) {
        }
    }

    protected void shaveOnYandX() throws ContradictionException {
        while (this.shaveOnY() && this.shaveOnX()) {
        }
    }
}

