/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.Arithm;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class NotEqualXYC
extends AbstractBinIntSConstraint {
    protected final int cste;

    public NotEqualXYC(IntDomainVar x0, IntDomainVar x1, int c) {
        super(x0, x1);
        this.cste = c;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v1.toString() + ") != VAL(" + this.v0.toString() + ") - " + this.cste);
            }
            this.v1.removeVal(this.v0.getVal() - this.cste, this.cIdx1);
        } else if (this.v1.isInstantiated()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v0.toString() + ") != VAL(" + this.v1.toString() + ") + " + this.cste);
            }
            this.v0.removeVal(this.v1.getVal() + this.cste, this.cIdx0);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.v0.isInstantiated()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v1.toString() + ") != VAL(" + this.v0.toString() + ") - " + this.cste);
            }
            this.v1.removeVal(this.v0.getVal() - this.cste, this.cIdx1);
        } else if (this.v1.isInstantiated()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v0.toString() + ") != VAL(" + this.v1.toString() + ") + " + this.cste);
            }
            this.v0.removeVal(this.v1.getVal() + this.cste, this.cIdx0);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.v0.isInstantiated()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v1.toString() + ") != VAL(" + this.v0.toString() + ") - " + this.cste);
            }
            this.v1.removeVal(this.v0.getVal() - this.cste, this.cIdx1);
        } else if (this.v1.isInstantiated()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v0.toString() + ") != VAL(" + this.v1.toString() + ") + " + this.cste);
            }
            this.v0.removeVal(this.v1.getVal() + this.cste, this.cIdx0);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v1.toString() + ") != VAL(" + this.v0.toString() + ") - " + this.cste);
            }
            this.v1.removeVal(this.v0.getVal() - this.cste, this.cIdx1);
        } else {
            assert (idx == 1);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("VAL(" + this.v0.toString() + ") != VAL(" + this.v1.toString() + ") + " + this.cste);
            }
            this.v0.removeVal(this.v1.getVal() + this.cste, this.cIdx0);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.getSup() < this.v1.getInf() + this.cste || this.v1.getSup() < this.v0.getInf() - this.cste) {
            return Boolean.TRUE;
        }
        if (this.v0.getInf() == this.v0.getSup() && this.v1.getInf() == this.v1.getSup() && this.v0.getInf() == this.v1.getInf() + this.cste) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] != tuple[1] + this.cste;
    }

    @Override
    public boolean isConsistent() {
        return this.v0.isInstantiated() ? (this.v1.hasEnumeratedDomain() ? !this.v1.canBeInstantiatedTo(this.v0.getVal()) : this.v1.getInf() != this.v0.getVal() && this.v1.getSup() != this.v0.getVal()) : (this.v1.isInstantiated() ? (this.v0.hasEnumeratedDomain() ? !this.v0.canBeInstantiatedTo(this.v1.getVal()) : this.v0.getInf() != this.v1.getVal() && this.v0.getSup() != this.v1.getVal()) : true);
    }

    @Override
    public AbstractSConstraint opposite() {
        Solver solver = this.getSolver();
        return (AbstractSConstraint)solver.eq((IntExp)this.v0, solver.plus((IntExp)this.v1, this.cste));
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0.toString());
        sb.append(" != ");
        sb.append(this.v1.toString());
        sb.append(Arithm.pretty(this.cste));
        return sb.toString();
    }
}

