/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class MinOfAList
extends AbstractLargeIntSConstraint {
    public static final int MIN_INDEX = 0;
    public static final int VARS_OFFSET = 1;
    protected final IStateInt indexOfMinimumVariable = this.getSolver().getEnvironment().makeInt(-1);

    public MinOfAList(IntDomainVar[] vars) {
        super(vars);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    protected void onlyOneMaxCandidatePropagation() throws ContradictionException {
        int idx;
        int nbVars = this.vars.length;
        IntDomainVar minVar = this.vars[0];
        if (this.indexOfMinimumVariable.get() == -1) {
            int minMin = Integer.MAX_VALUE;
            int minMinIdx = -1;
            int minMin2 = Integer.MAX_VALUE;
            int minMin2Idx = -1;
            for (int i = 1; i < nbVars; ++i) {
                int val = this.vars[i].getInf();
                if (val <= minMin) {
                    minMin2 = minMin;
                    minMin2Idx = minMinIdx;
                    minMin = val;
                    minMinIdx = i;
                    continue;
                }
                if (val >= minMin2) continue;
                minMin2 = val;
                minMin2Idx = i;
            }
            if (minMin2 > minVar.getSup()) {
                this.indexOfMinimumVariable.set(minMinIdx);
            }
        }
        if ((idx = this.indexOfMinimumVariable.get()) != -1) {
            minVar.updateSup(this.vars[idx].getSup(), this.getConstraintIdx(0));
            this.vars[idx].updateSup(minVar.getSup(), this.getConstraintIdx(idx));
        }
    }

    protected boolean testIfOneCandidateToTakeMaxValue() {
        int minValue = this.vars[0].getVal();
        int nbVars = this.vars.length;
        boolean existsInstantiated = false;
        for (int i = 1; i < nbVars; ++i) {
            if (this.vars[i].getInf() <= minValue) {
                return false;
            }
            if (this.vars[i].getSup() != minValue) continue;
            existsInstantiated = true;
        }
        return existsInstantiated;
    }

    protected final int minInf() {
        int nbVars = this.vars.length;
        int min = Integer.MAX_VALUE;
        for (int i = 1; i < nbVars; ++i) {
            int val = this.vars[i].getInf();
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    protected final int minSup() {
        int nbVars = this.vars.length;
        int min = Integer.MAX_VALUE;
        for (int i = 1; i < nbVars; ++i) {
            int val = this.vars[i].getSup();
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    @Override
    public void propagate() throws ContradictionException {
        int nbVars = this.vars.length;
        IntDomainVar minVar = this.vars[0];
        minVar.updateInf(this.minInf(), this.getConstraintIdx(0));
        minVar.updateSup(this.minSup(), this.getConstraintIdx(0));
        int minValue = minVar.getInf();
        for (int i = 1; i < nbVars; ++i) {
            this.vars[i].updateInf(minValue, this.getConstraintIdx(i));
        }
        this.onlyOneMaxCandidatePropagation();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx >= 1) {
            this.vars[0].updateInf(this.minInf(), this.getConstraintIdx(0));
            this.onlyOneMaxCandidatePropagation();
        } else {
            int nbVars = this.vars.length;
            int minVal = this.vars[0].getInf();
            for (int i = 1; i < nbVars; ++i) {
                this.vars[i].updateInf(minVal, this.getConstraintIdx(i));
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx >= 1) {
            this.vars[0].updateSup(this.minSup(), this.getConstraintIdx(0));
        } else {
            this.onlyOneMaxCandidatePropagation();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx >= 1) {
            IntDomainVar minVar = this.vars[0];
            minVar.updateInf(this.minInf(), this.getConstraintIdx(0));
            minVar.updateSup(this.minSup(), this.getConstraintIdx(0));
        } else {
            int nbVars = this.vars.length;
            int minValue = this.vars[0].getInf();
            for (int i = 1; i < nbVars; ++i) {
                this.vars[i].updateInf(minValue, this.getConstraintIdx(i));
            }
            this.onlyOneMaxCandidatePropagation();
        }
    }

    @Override
    public Boolean isEntailed() {
        int minInf = this.vars[0].getInf();
        int minSup = this.vars[0].getSup();
        int cptIn = 0;
        int cptBelow = 0;
        for (int i = 1; i < this.vars.length; ++i) {
            IntDomainVar tmp = this.vars[i];
            int inf = tmp.getInf();
            int sup = tmp.getSup();
            if (inf == minInf && minSup == sup && sup == inf) {
                ++cptIn;
                continue;
            }
            if (sup < minInf) {
                return Boolean.FALSE;
            }
            if (inf <= minSup) continue;
            ++cptBelow;
        }
        if (cptBelow == this.vars.length - 1) {
            return Boolean.FALSE;
        }
        if (cptIn > 0) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int minValue = Integer.MAX_VALUE;
        for (int i = 1; i < this.vars.length; ++i) {
            if (minValue <= tuple[i]) continue;
            minValue = tuple[i];
        }
        return tuple[0] == minValue;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.vars[0].pretty()).append(" = min({");
        for (int i = 1; i < this.vars.length; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(this.vars[i].pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

