/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class MaxXYZ
extends AbstractTernIntSConstraint {
    public MaxXYZ(IntDomainVar x, IntDomainVar y, IntDomainVar max) {
        super(max, x, y);
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return Math.max(tuple[2], tuple[1]) == tuple[0];
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (idx == 1) {
            if (this.v1.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v2.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public String pretty() {
        return "max(" + this.v2.pretty() + "," + this.v1.pretty() + ") = " + this.v0.pretty();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.v1.updateSup(this.v0.getSup(), this.cIdx1);
            this.v2.updateSup(this.v0.getSup(), this.cIdx2);
        } else {
            this.v0.updateSup(Math.max(this.v1.getSup(), this.v2.getSup()), this.cIdx0);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            if (this.v1.getInf() > this.v2.getSup()) {
                this.v1.updateInf(this.v0.getInf(), this.cIdx1);
            }
            if (this.v2.getInf() > this.v1.getSup()) {
                this.v2.updateInf(this.v0.getInf(), this.cIdx2);
            }
        } else {
            this.v0.updateInf(Math.max(this.v1.getInf(), this.v2.getInf()), this.cIdx2);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx == 0) {
            if (x > this.v2.getSup()) {
                this.v1.removeVal(x, this.cIdx1);
            }
            if (x > this.v1.getSup()) {
                this.v2.removeVal(x, this.cIdx2);
            }
        } else if (!this.v1.canBeInstantiatedTo(x) && !this.v2.canBeInstantiatedTo(x)) {
            this.v0.removeVal(x, this.cIdx0);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter(0);
        this.filter(1);
        this.filter(2);
    }

    public void filter(int idx) throws ContradictionException {
        if (idx == 0) {
            this.v0.updateSup(Math.max(this.v1.getSup(), this.v2.getSup()), this.cIdx0);
            this.v0.updateInf(Math.max(this.v1.getInf(), this.v2.getInf()), this.cIdx0);
            if (this.v0.hasEnumeratedDomain()) {
                IntDomain dom0 = this.v0.getDomain();
                DisposableIntIterator it = dom0.getIterator();
                while (it.hasNext()) {
                    int valeur = it.next();
                    if (this.v1.canBeInstantiatedTo(valeur) || this.v2.canBeInstantiatedTo(valeur)) continue;
                    this.v0.removeVal(valeur, this.cIdx0);
                }
                it.dispose();
            }
        } else if (idx == 1) {
            this.v1.updateSup(this.v0.getSup(), this.cIdx1);
            if (this.v1.getInf() > this.v2.getSup()) {
                this.v1.updateInf(this.v0.getInf(), this.cIdx1);
            }
            if (this.v1.hasEnumeratedDomain()) {
                IntDomain dom1 = this.v1.getDomain();
                DisposableIntIterator it = dom1.getIterator();
                while (it.hasNext()) {
                    int valeur = it.next();
                    if (this.v0.canBeInstantiatedTo(valeur) || valeur <= this.v2.getSup()) continue;
                    this.v1.removeVal(valeur, this.cIdx1);
                }
                it.dispose();
            }
        } else if (idx == 2) {
            this.v2.updateSup(this.v0.getSup(), this.cIdx2);
            if (this.v2.getInf() > this.v1.getSup()) {
                this.v2.updateInf(this.v0.getInf(), this.cIdx2);
            }
            if (this.v2.hasEnumeratedDomain()) {
                IntDomain dom2 = this.v2.getDomain();
                DisposableIntIterator it = dom2.getIterator();
                while (it.hasNext()) {
                    int valeur = it.next();
                    if (this.v0.canBeInstantiatedTo(valeur) || valeur <= this.v1.getSup()) continue;
                    this.v2.removeVal(valeur, this.cIdx2);
                }
                it.dispose();
            }
        }
    }

    public void awakeOnInst(int idx, int val) throws ContradictionException {
        if (idx == 0) {
            this.v1.updateSup(val, this.cIdx1);
            this.v2.updateSup(val, this.cIdx2);
            if (!this.v1.canBeInstantiatedTo(val)) {
                this.v2.instantiate(val, this.cIdx2);
            }
            if (!this.v2.canBeInstantiatedTo(val)) {
                this.v1.instantiate(val, this.cIdx1);
            }
        } else if (idx == 1) {
            if (val > this.v2.getSup()) {
                this.v0.instantiate(val, this.cIdx0);
            }
        } else if (idx == 2 && val > this.v1.getSup()) {
            this.v0.instantiate(val, this.cIdx0);
        }
    }
}

